/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import org.jcp.xml.dsig.internal.DigesterOutputStream;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMReference
extends DOMStructure
implements Reference,
DOMURIReference {
    private static boolean useC14N11 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11");
        }
    });
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private final DigestMethod digestMethod;
    private final String id;
    private final List transforms;
    private List allTransforms;
    private final Data appliedTransformData;
    private Attr here;
    private final String uri;
    private final String type;
    private byte[] digestValue;
    private byte[] calcDigestValue;
    private Element refElem;
    private boolean digested = false;
    private boolean validated = false;
    private boolean validationStatus;
    private Data derefData;
    private InputStream dis;
    private MessageDigest md;
    private Provider provider;

    public DOMReference(String string, String string2, DigestMethod digestMethod, List list, String string3, Provider provider) {
        this(string, string2, digestMethod, null, null, list, string3, null, provider);
    }

    public DOMReference(String string, String string2, DigestMethod digestMethod, List list, Data data, List list2, String string3, Provider provider) {
        this(string, string2, digestMethod, list, data, list2, string3, null, provider);
    }

    public DOMReference(String string, String string2, DigestMethod digestMethod, List list, Data data, List list2, String string3, byte[] byArray, Provider provider) {
        int n;
        int n2;
        ArrayList arrayList;
        if (digestMethod == null) {
            throw new NullPointerException("DigestMethod must be non-null");
        }
        this.allTransforms = new ArrayList();
        if (list != null) {
            arrayList = new ArrayList(list);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (arrayList.get(n) instanceof Transform) continue;
                throw new ClassCastException("appliedTransforms[" + n + "] is not a valid type");
            }
            this.allTransforms = arrayList;
        }
        if (list2 == null) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList(list2);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (arrayList.get(n) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + n + "] is not a valid type");
            }
            this.transforms = arrayList;
            this.allTransforms.addAll(arrayList);
        }
        this.digestMethod = digestMethod;
        this.uri = string;
        if (string != null && !string.equals("")) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException.getMessage());
            }
        }
        this.type = string2;
        this.id = string3;
        if (byArray != null) {
            this.digestValue = (byte[])byArray.clone();
            this.digested = true;
        }
        this.appliedTransformData = data;
        this.provider = provider;
    }

    public DOMReference(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        Element element2;
        Element element3 = DOMUtils.getFirstChildElement(element);
        ArrayList<DOMTransform> arrayList = new ArrayList<DOMTransform>(5);
        if (element3.getLocalName().equals("Transforms")) {
            element2 = DOMUtils.getFirstChildElement(element3);
            while (element2 != null) {
                arrayList.add(new DOMTransform(element2, xMLCryptoContext, provider));
                element2 = DOMUtils.getNextSiblingElement(element2);
            }
            element3 = DOMUtils.getNextSiblingElement(element3);
        }
        element2 = element3;
        this.digestMethod = DOMDigestMethod.unmarshal(element2);
        try {
            Element element4 = DOMUtils.getNextSiblingElement(element2);
            this.digestValue = Base64.decode(element4);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new MarshalException(base64DecodingException);
        }
        this.uri = DOMUtils.getAttributeValue(element, "URI");
        this.id = DOMUtils.getAttributeValue(element, "Id");
        this.type = DOMUtils.getAttributeValue(element, "Type");
        this.here = element.getAttributeNodeNS(null, "URI");
        this.refElem = element;
        this.transforms = arrayList;
        this.allTransforms = arrayList;
        this.appliedTransformData = null;
        this.provider = provider;
    }

    @Override
    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List getTransforms() {
        return Collections.unmodifiableList(this.allTransforms);
    }

    @Override
    public byte[] getDigestValue() {
        return this.digestValue == null ? null : (byte[])this.digestValue.clone();
    }

    @Override
    public byte[] getCalculatedDigestValue() {
        return this.calcDigestValue == null ? null : (byte[])this.calcDigestValue.clone();
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Marshalling Reference");
        }
        Document document = DOMUtils.getOwnerDocument(node);
        this.refElem = DOMUtils.createElement(document, "Reference", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMUtils.setAttributeID(this.refElem, "Id", this.id);
        DOMUtils.setAttribute(this.refElem, "URI", this.uri);
        DOMUtils.setAttribute(this.refElem, "Type", this.type);
        if (!this.allTransforms.isEmpty()) {
            element = DOMUtils.createElement(document, "Transforms", "http://www.w3.org/2000/09/xmldsig#", string);
            this.refElem.appendChild(element);
            int n = this.allTransforms.size();
            for (int i = 0; i < n; ++i) {
                DOMStructure dOMStructure = (DOMStructure)this.allTransforms.get(i);
                dOMStructure.marshal(element, string, dOMCryptoContext);
            }
        }
        ((DOMDigestMethod)this.digestMethod).marshal(this.refElem, string, dOMCryptoContext);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Adding digestValueElem");
        }
        element = DOMUtils.createElement(document, "DigestValue", "http://www.w3.org/2000/09/xmldsig#", string);
        if (this.digestValue != null) {
            element.appendChild(document.createTextNode(Base64.encode(this.digestValue)));
        }
        this.refElem.appendChild(element);
        node.appendChild(this.refElem);
        this.here = this.refElem.getAttributeNodeNS(null, "URI");
    }

    public void digest(XMLSignContext xMLSignContext) throws XMLSignatureException {
        Element element;
        Data data = null;
        data = this.appliedTransformData == null ? this.dereference(xMLSignContext) : this.appliedTransformData;
        this.digestValue = this.transform(data, xMLSignContext);
        String string = Base64.encode(this.digestValue);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference object uri = " + this.uri);
        }
        if ((element = DOMUtils.getLastChildElement(this.refElem)) == null) {
            throw new XMLSignatureException("DigestValue element expected");
        }
        DOMUtils.removeAllChildren(element);
        element.appendChild(this.refElem.getOwnerDocument().createTextNode(string));
        this.digested = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Reference digesting completed");
        }
    }

    @Override
    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        Data data = this.dereference(xMLValidateContext);
        this.calcDigestValue = this.transform(data, xMLValidateContext);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Expected digest: " + Base64.encode(this.digestValue));
            log.log(Level.FINE, "Actual digest: " + Base64.encode(this.calcDigestValue));
        }
        this.validationStatus = Arrays.equals(this.digestValue, this.calcDigestValue);
        this.validated = true;
        return this.validationStatus;
    }

    @Override
    public Data getDereferencedData() {
        return this.derefData;
    }

    @Override
    public InputStream getDigestInputStream() {
        return this.dis;
    }

    private Data dereference(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Data data = null;
        URIDereferencer uRIDereferencer = xMLCryptoContext.getURIDereferencer();
        if (uRIDereferencer == null) {
            uRIDereferencer = DOMURIDereferencer.INSTANCE;
        }
        try {
            data = uRIDereferencer.dereference(this, xMLCryptoContext);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "URIDereferencer class name: " + uRIDereferencer.getClass().getName());
                log.log(Level.FINE, "Data class name: " + data.getClass().getName());
            }
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException(uRIReferenceException);
        }
        return data;
    }

    private byte[] transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Object object;
        DigesterOutputStream digesterOutputStream;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(((DOMDigestMethod)this.digestMethod).getMessageDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        this.md.reset();
        Boolean bl = (Boolean)xMLCryptoContext.getProperty("javax.xml.crypto.dsig.cacheReference");
        if (bl != null && bl.booleanValue()) {
            this.derefData = DOMReference.copyDerefData(data);
            digesterOutputStream = new DigesterOutputStream(this.md, true);
        } else {
            digesterOutputStream = new DigesterOutputStream(this.md);
        }
        UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(digesterOutputStream);
        Data data2 = data;
        int n = this.transforms.size();
        for (int i = 0; i < n; ++i) {
            object = (DOMTransform)this.transforms.get(i);
            try {
                if (i < n - 1) {
                    data2 = ((DOMTransform)object).transform(data2, xMLCryptoContext);
                    continue;
                }
                data2 = ((DOMTransform)object).transform(data2, xMLCryptoContext, unsyncBufferedOutputStream);
                continue;
            }
            catch (TransformException transformException) {
                throw new XMLSignatureException(transformException);
            }
        }
        try {
            if (data2 != null) {
                XMLSignatureInput xMLSignatureInput;
                Object object2;
                n = useC14N11 ? 1 : 0;
                object = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
                if (xMLCryptoContext instanceof XMLSignContext) {
                    if (n == 0) {
                        object2 = (Boolean)xMLCryptoContext.getProperty("com.sun.org.apache.xml.internal.security.useC14N11");
                        int n2 = n = object2 != null && ((Boolean)object2).booleanValue() ? 1 : 0;
                        if (n != 0) {
                            object = "http://www.w3.org/2006/12/xml-c14n11";
                        }
                    } else {
                        object = "http://www.w3.org/2006/12/xml-c14n11";
                    }
                }
                if (data2 instanceof ApacheData) {
                    xMLSignatureInput = ((ApacheData)data2).getXMLSignatureInput();
                } else if (data2 instanceof OctetStreamData) {
                    xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data2).getOctetStream());
                } else if (data2 instanceof NodeSetData) {
                    object2 = null;
                    try {
                        object2 = TransformService.getInstance((String)object, "DOM");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        object2 = TransformService.getInstance((String)object, "DOM", this.provider);
                    }
                    data2 = object2.transform(data2, xMLCryptoContext);
                    xMLSignatureInput = new XMLSignatureInput(((OctetStreamData)data2).getOctetStream());
                } else {
                    throw new XMLSignatureException("unrecognized Data type");
                }
                if (xMLCryptoContext instanceof XMLSignContext && n != 0 && !xMLSignatureInput.isOctetStream() && !xMLSignatureInput.isOutputStreamSet()) {
                    object2 = new DOMTransform(TransformService.getInstance((String)object, "DOM"));
                    Element element = null;
                    String string = DOMUtils.getSignaturePrefix(xMLCryptoContext);
                    if (this.allTransforms.isEmpty()) {
                        element = DOMUtils.createElement(this.refElem.getOwnerDocument(), "Transforms", "http://www.w3.org/2000/09/xmldsig#", string);
                        this.refElem.insertBefore(element, DOMUtils.getFirstChildElement(this.refElem));
                    } else {
                        element = DOMUtils.getFirstChildElement(this.refElem);
                    }
                    ((DOMTransform)object2).marshal(element, string, (DOMCryptoContext)xMLCryptoContext);
                    this.allTransforms.add(object2);
                    xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream, true);
                } else {
                    xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream);
                }
            }
            ((OutputStream)unsyncBufferedOutputStream).flush();
            if (bl != null && bl.booleanValue()) {
                this.dis = digesterOutputStream.getInputStream();
            }
            return digesterOutputStream.getDigestValue();
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception);
        }
    }

    @Override
    public Node getHere() {
        return this.here;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)object;
        boolean bl3 = this.id == null ? reference.getId() == null : (bl2 = this.id.equals(reference.getId()));
        boolean bl4 = this.uri == null ? reference.getURI() == null : (bl = this.uri.equals(reference.getURI()));
        boolean bl5 = this.type == null ? reference.getType() == null : this.type.equals(reference.getType());
        boolean bl6 = Arrays.equals(this.digestValue, reference.getDigestValue());
        return this.digestMethod.equals(reference.getDigestMethod()) && bl2 && bl && bl5 && this.allTransforms.equals(reference.getTransforms());
    }

    boolean isDigested() {
        return this.digested;
    }

    private static Data copyDerefData(Data data) {
        if (data instanceof ApacheData) {
            ApacheData apacheData = (ApacheData)data;
            XMLSignatureInput xMLSignatureInput = apacheData.getXMLSignatureInput();
            if (xMLSignatureInput.isNodeSet()) {
                try {
                    final Set set = xMLSignatureInput.getNodeSet();
                    return new NodeSetData(){

                        @Override
                        public Iterator iterator() {
                            return set.iterator();
                        }
                    };
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + exception);
                    return null;
                }
            }
            if (xMLSignatureInput.isElement()) {
                return new DOMSubTreeData(xMLSignatureInput.getSubNode(), xMLSignatureInput.isExcludeComments());
            }
            if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isByteArray()) {
                try {
                    return new OctetStreamData(xMLSignatureInput.getOctetStream(), xMLSignatureInput.getSourceURI(), xMLSignatureInput.getMIMEType());
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "cannot cache dereferenced data: " + iOException);
                    return null;
                }
            }
        }
        return data;
    }
}

