/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.ThreadGroupIterator;
import com.sun.tools.example.debug.bdi.ThreadIterator;
import com.sun.tools.example.debug.bdi.Utils;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.LaunchTool;
import com.sun.tools.example.debug.gui.OutputSink;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourceModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CommandInterpreter {
    boolean echo;
    Environment env;
    private ContextManager context;
    private ExecutionManager runtime;
    private ClassManager classManager;
    private SourceManager sourceManager;
    private OutputSink out;
    private String lastCommand = "help";
    private ThreadReference[] threads = null;
    private ThreadGroupReference defaultThreadGroup;

    public CommandInterpreter(Environment environment) {
        this(environment, true);
    }

    public CommandInterpreter(Environment environment, boolean bl) {
        this.env = environment;
        this.echo = bl;
        this.runtime = environment.getExecutionManager();
        this.context = environment.getContextManager();
        this.classManager = environment.getClassManager();
        this.sourceManager = environment.getSourceManager();
    }

    private ThreadReference[] threads() throws NoSessionException {
        if (this.threads == null) {
            ThreadIterator threadIterator = new ThreadIterator(this.getDefaultThreadGroup());
            ArrayList<ThreadReference> arrayList = new ArrayList<ThreadReference>();
            while (threadIterator.hasNext()) {
                arrayList.add(threadIterator.nextThread());
            }
            this.threads = arrayList.toArray(new ThreadReference[arrayList.size()]);
        }
        return this.threads;
    }

    private ThreadReference findThread(String string) throws NoSessionException {
        ThreadReference threadReference = null;
        String string2 = string.startsWith("t@") ? string.substring(2) : string;
        try {
            ThreadReference[] threadReferenceArray = this.threads();
            long l = Long.parseLong(string2, 16);
            for (int i = 0; i < threadReferenceArray.length; ++i) {
                if (threadReferenceArray[i].uniqueID() != l) continue;
                threadReference = threadReferenceArray[i];
                break;
            }
            if (threadReference == null) {
                this.env.failure("\"" + string + "\" is not a valid thread id.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.env.error("Thread id \"" + string + "\" is ill-formed.");
            threadReference = null;
        }
        return threadReference;
    }

    private ThreadIterator allThreads() throws NoSessionException {
        this.threads = null;
        return new ThreadIterator(this.runtime.topLevelThreadGroups());
    }

    private ThreadIterator currentThreadGroupThreads() throws NoSessionException {
        this.threads = null;
        return new ThreadIterator(this.getDefaultThreadGroup());
    }

    private ThreadGroupIterator allThreadGroups() throws NoSessionException {
        this.threads = null;
        return new ThreadGroupIterator(this.runtime.topLevelThreadGroups());
    }

    private ThreadGroupReference getDefaultThreadGroup() throws NoSessionException {
        if (this.defaultThreadGroup == null) {
            this.defaultThreadGroup = this.runtime.systemThreadGroup();
        }
        return this.defaultThreadGroup;
    }

    private void setDefaultThreadGroup(ThreadGroupReference threadGroupReference) {
        this.defaultThreadGroup = threadGroupReference;
    }

    private void commandClasses() throws NoSessionException {
        OutputSink outputSink = this.env.getOutputSink();
        for (ReferenceType referenceType : this.runtime.allClasses()) {
            outputSink.println(referenceType.name());
        }
        outputSink.show();
    }

    private void commandMethods(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = this.findClass(string);
        if (referenceType != null) {
            List<Method> list = referenceType.allMethods();
            OutputSink outputSink = this.env.getOutputSink();
            for (int i = 0; i < list.size(); ++i) {
                Method method = list.get(i);
                outputSink.print(method.declaringType().name() + " " + method.name() + "(");
                Iterator<String> iterator = method.argumentTypeNames().iterator();
                if (iterator.hasNext()) {
                    while (true) {
                        outputSink.print(iterator.next());
                        if (!iterator.hasNext()) break;
                        outputSink.print(", ");
                    }
                }
                outputSink.println(")");
            }
            outputSink.show();
        } else {
            this.env.failure("\"" + string + "\" is not a valid id or class name.");
        }
    }

    private ReferenceType findClass(String string) throws NoSessionException {
        List<ReferenceType> list = this.runtime.findClassesMatchingPattern(string);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private void commandThreads(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            OutputSink outputSink = this.env.getOutputSink();
            this.printThreadGroup(outputSink, this.getDefaultThreadGroup(), 0);
            outputSink.show();
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = this.findThreadGroup(string);
        if (threadGroupReference == null) {
            this.env.failure(string + " is not a valid threadgroup name.");
        } else {
            OutputSink outputSink = this.env.getOutputSink();
            this.printThreadGroup(outputSink, threadGroupReference, 0);
            outputSink.show();
        }
    }

    private ThreadGroupReference findThreadGroup(String string) throws NoSessionException {
        ThreadGroupIterator threadGroupIterator = this.allThreadGroups();
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            if (!threadGroupReference.name().equals(string)) continue;
            return threadGroupReference;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int printThreadGroup(OutputSink outputSink, ThreadGroupReference threadGroupReference, int n) {
        int n2;
        outputSink.println("Group " + threadGroupReference.name() + ":");
        List<ThreadReference> list = threadGroupReference.threads();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < list.size(); ++i) {
            void object2;
            String string;
            int n5;
            ThreadReference threadReference = list.get(i);
            n2 = Utils.description(threadReference).length();
            if (n2 > n3) {
                n3 = n2;
            }
            if ((n5 = (string = threadReference.name()).lastIndexOf(46)) >= 0 && string.length() > n5) {
                String string2 = string.substring(n5 + 1);
            }
            if (object2.length() <= n4) continue;
            n4 = object2.length();
        }
        String string = String.valueOf(n + list.size());
        int n6 = string.length();
        for (n2 = 0; n2 < list.size(); ++n2) {
            ThreadReference threadReference = list.get(n2);
            char[] cArray = new char[80];
            for (int i = 0; i < 79; ++i) {
                cArray[i] = 32;
            }
            cArray[79] = '\u0000';
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            String string3 = String.valueOf(n + n2 + 1);
            stringBuffer.insert(n6 - string3.length(), string3);
            stringBuffer.insert(n6, ".");
            int n7 = n6 + 2;
            stringBuffer.insert(n7, Utils.description(threadReference));
            n7 += n3 + 1;
            String string4 = threadReference.name();
            int n8 = string4.lastIndexOf(46);
            if (n8 >= 0 && string4.length() > n8) {
                string4 = string4.substring(n8 + 1);
            }
            stringBuffer.insert(n7, string4);
            stringBuffer.insert(n7 += n4 + 1, Utils.getStatus(threadReference));
            stringBuffer.setLength(79);
            outputSink.println(stringBuffer.toString());
        }
        for (ThreadGroupReference threadGroupReference2 : threadGroupReference.threadGroups()) {
            if (threadGroupReference.equals(threadGroupReference2)) continue;
            n += this.printThreadGroup(outputSink, threadGroupReference2, n + list.size());
        }
        return list.size();
    }

    private void commandThreadGroups() throws NoSessionException {
        ThreadGroupIterator threadGroupIterator = this.allThreadGroups();
        int n = 0;
        OutputSink outputSink = this.env.getOutputSink();
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            outputSink.println("" + ++n + ". " + Utils.description(threadGroupReference) + " " + threadGroupReference.name());
        }
        outputSink.show();
    }

    private void commandThread(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Thread number not specified.");
            return;
        }
        ThreadReference threadReference = this.findThread(stringTokenizer.nextToken());
        if (threadReference != null) {
            this.context.setCurrentThread(threadReference);
        }
    }

    private void commandThreadGroup(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = this.findThreadGroup(string);
        if (threadGroupReference == null) {
            this.env.failure(string + " is not a valid threadgroup name.");
        } else {
            this.setDefaultThreadGroup(threadGroupReference);
        }
    }

    private void commandRun(StringTokenizer stringTokenizer) throws NoSessionException {
        if (this.doLoad(false, stringTokenizer)) {
            this.env.notice("Running ...");
        }
    }

    private void commandLoad(StringTokenizer stringTokenizer) throws NoSessionException {
        if (this.doLoad(true, stringTokenizer)) {
            // empty if block
        }
    }

    private boolean doLoad(boolean bl, StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            String string = this.context.getMainClassName();
            if (!string.equals("")) {
                try {
                    String string2 = this.context.getVmArguments();
                    this.runtime.run(bl, string2, string, this.context.getProgramArguments());
                    return true;
                }
                catch (VMLaunchFailureException vMLaunchFailureException) {
                    this.env.failure("Attempt to launch main class \"" + string + "\" failed.");
                }
            } else {
                this.env.failure("No main class specifed and no current default defined.");
            }
        } else {
            String string;
            String string3 = stringTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                stringBuffer.append(string);
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
            try {
                String string4 = this.context.getVmArguments();
                this.runtime.run(bl, string4, string3, string);
                this.context.setMainClassName(string3);
                this.context.setProgramArguments(string);
                return true;
            }
            catch (VMLaunchFailureException vMLaunchFailureException) {
                this.env.failure("Attempt to launch main class \"" + string3 + "\" failed.");
            }
        }
        return false;
    }

    private void commandConnect(StringTokenizer stringTokenizer) {
        try {
            LaunchTool.queryAndLaunchVM(this.runtime);
        }
        catch (VMLaunchFailureException vMLaunchFailureException) {
            this.env.failure("Attempt to connect failed.");
        }
    }

    private void commandAttach(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            String string = this.context.getRemotePort();
            if (!string.equals("")) {
                try {
                    this.runtime.attach(string);
                }
                catch (VMLaunchFailureException vMLaunchFailureException) {
                    this.env.failure("Attempt to attach to port \"" + string + "\" failed.");
                }
            } else {
                this.env.failure("No port specifed and no current default defined.");
            }
        } else {
            String string = stringTokenizer.nextToken();
            try {
                this.runtime.attach(string);
            }
            catch (VMLaunchFailureException vMLaunchFailureException) {
                this.env.failure("Attempt to attach to port \"" + string + "\" failed.");
            }
            this.context.setRemotePort(string);
        }
    }

    private void commandDetach(StringTokenizer stringTokenizer) throws NoSessionException {
        this.runtime.detach();
    }

    private void commandInterrupt(StringTokenizer stringTokenizer) throws NoSessionException {
        this.runtime.interrupt();
    }

    private void commandSuspend(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadIterator threadIterator = this.currentThreadGroupThreads();
            while (threadIterator.hasNext()) {
                threadIterator.nextThread().suspend();
            }
            this.env.notice("All (non-system) threads suspended.");
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                ThreadReference threadReference = this.findThread(stringTokenizer.nextToken());
                if (threadReference == null) continue;
                this.runtime.suspendThread(threadReference);
            }
        }
    }

    private void commandResume(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadIterator threadIterator = this.currentThreadGroupThreads();
            while (threadIterator.hasNext()) {
                threadIterator.nextThread().resume();
            }
            this.env.notice("All threads resumed.");
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                ThreadReference threadReference = this.findThread(stringTokenizer.nextToken());
                if (threadReference == null) continue;
                this.runtime.resumeThread(threadReference);
            }
        }
    }

    private void commandCont() throws NoSessionException {
        try {
            this.runtime.go();
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.notice("Target VM is already running.");
        }
    }

    private void commandStep(StringTokenizer stringTokenizer) throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        try {
            if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().toLowerCase().equals("up")) {
                this.runtime.stepOut(threadReference);
            } else {
                this.runtime.stepIntoLine(threadReference);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            this.env.failure("No linenumber information available -- Try \"stepi\" to step by instructions.");
        }
    }

    private void commandStepi() throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        this.runtime.stepIntoInstruction(threadReference);
    }

    private void commandNext() throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        try {
            this.runtime.stepOverLine(threadReference);
        }
        catch (AbsentInformationException absentInformationException) {
            this.env.failure("No linenumber information available -- Try \"nexti\" to step by instructions.");
        }
    }

    private void commandNexti() throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        this.runtime.stepOverInstruction(threadReference);
    }

    private void commandKill(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Usage: kill <threadgroup name> or <thread id>");
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            ThreadReference threadReference = this.findThread(string);
            if (threadReference != null) {
                this.runtime.stopThread(threadReference);
                this.env.notice("Thread " + threadReference.name() + " killed.");
                return;
            }
            ThreadGroupIterator threadGroupIterator = this.allThreadGroups();
            while (threadGroupIterator.hasNext()) {
                ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
                if (!threadGroupReference.name().equals(string)) continue;
                ThreadIterator threadIterator = new ThreadIterator(threadGroupReference);
                while (threadIterator.hasNext()) {
                    this.runtime.stopThread(threadIterator.nextThread());
                }
                this.env.notice("Threadgroup " + threadGroupReference.name() + "killed.");
                return;
            }
            this.env.failure("\"" + string + "\" is not a valid threadgroup or id.");
        }
    }

    int readCount(StringTokenizer stringTokenizer) {
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    void commandUp(StringTokenizer stringTokenizer) throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        int n = this.readCount(stringTokenizer);
        if (n <= 0) {
            this.env.error("usage: up [n frames]");
            return;
        }
        try {
            int n2 = this.context.moveCurrentFrameIndex(threadReference, -n);
            if (n2 == 0) {
                this.env.notice("Already at top of stack.");
            } else if (-n2 < n) {
                this.env.notice("Moved up " + n2 + " frames to top of stack.");
            }
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandDown(StringTokenizer stringTokenizer) throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        int n = this.readCount(stringTokenizer);
        if (n <= 0) {
            this.env.error("usage: down [n frames]");
            return;
        }
        try {
            int n2 = this.context.moveCurrentFrameIndex(threadReference, n);
            if (n2 == 0) {
                this.env.notice("Already at bottom of stack.");
            } else if (n2 < n) {
                this.env.notice("Moved down " + n2 + " frames to bottom of stack.");
            }
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandFrame(StringTokenizer stringTokenizer) throws NoSessionException {
        int n;
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No current thread.");
            return;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("usage: frame <frame-index>");
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n <= 0) {
            this.env.error("use positive frame index");
            return;
        }
        try {
            int n2 = this.context.setCurrentFrameIndex(threadReference, n);
            if (n2 == 0) {
                this.env.notice("Frame unchanged.");
            } else if (n2 < 0) {
                this.env.notice("Moved up " + -n2 + " frames.");
            } else {
                this.env.notice("Moved down " + n2 + " frames.");
            }
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandWhere(StringTokenizer stringTokenizer, boolean bl) throws NoSessionException {
        ThreadReference threadReference = this.context.getCurrentThread();
        if (!stringTokenizer.hasMoreTokens()) {
            if (threadReference == null) {
                this.env.error("No thread specified.");
                return;
            }
            this.dumpStack(threadReference, bl);
        } else {
            String string = stringTokenizer.nextToken();
            if (string.toLowerCase().equals("all")) {
                ThreadIterator threadIterator = this.allThreads();
                while (threadIterator.hasNext()) {
                    ThreadReference threadReference2 = threadIterator.next();
                    this.out.println(threadReference2.name() + ": ");
                    this.dumpStack(threadReference2, bl);
                }
            } else {
                ThreadReference threadReference3 = this.findThread(stringTokenizer.nextToken());
                if (threadReference3 != null) {
                    this.context.setCurrentThread(threadReference3);
                }
                this.dumpStack(threadReference3, bl);
            }
        }
    }

    private void dumpStack(ThreadReference threadReference, boolean bl) {
        List<StackFrame> list = null;
        try {
            list = threadReference.frames();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            this.env.failure("Thread is not suspended.");
        }
        int n = 0;
        if (list == null) {
            this.env.failure("Thread is not running (no stack).");
        } else {
            OutputSink outputSink = this.env.getOutputSink();
            int n2 = list.size();
            for (int i = n; i < n2; ++i) {
                long l;
                StackFrame stackFrame = list.get(i);
                Location location = stackFrame.location();
                Method method = location.method();
                outputSink.print("  [" + (i + 1) + "] ");
                outputSink.print(method.declaringType().name());
                outputSink.print('.');
                outputSink.print(method.name());
                outputSink.print(" (");
                if (method.isNative()) {
                    outputSink.print("native method");
                } else if (location.lineNumber() != -1) {
                    try {
                        outputSink.print(location.sourceName());
                    }
                    catch (AbsentInformationException absentInformationException) {
                        outputSink.print("<unknown>");
                    }
                    outputSink.print(':');
                    outputSink.print(location.lineNumber());
                }
                outputSink.print(')');
                if (bl && (l = location.codeIndex()) != -1L) {
                    outputSink.print(", pc = " + l);
                }
                outputSink.println();
            }
            outputSink.show();
        }
    }

    private void listEventRequests() throws NoSessionException {
        List<EventRequestSpec> list = this.runtime.eventRequestSpecs();
        if (list.isEmpty()) {
            this.env.notice("No breakpoints/watchpoints/exceptions set.");
        } else {
            OutputSink outputSink = this.env.getOutputSink();
            outputSink.println("Current breakpoints/watchpoints/exceptions set:");
            for (EventRequestSpec eventRequestSpec : list) {
                outputSink.println("\t" + eventRequestSpec);
            }
            outputSink.show();
        }
    }

    private BreakpointSpec parseBreakpointSpec(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        BreakpointSpec breakpointSpec = null;
        String string3 = stringTokenizer.nextToken("@:( \t\n\r");
        try {
            string2 = stringTokenizer.nextToken("").trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = null;
        }
        if (string2 != null && string2.startsWith("@")) {
            stringTokenizer = new StringTokenizer(string2.substring(1));
            String string4 = string3;
            String string5 = stringTokenizer.nextToken();
            int n = Integer.valueOf(string5);
            if (stringTokenizer.hasMoreTokens()) {
                return null;
            }
            breakpointSpec = this.runtime.createSourceLineBreakpoint(string4, n);
        } else if (string2 != null && string2.startsWith(":")) {
            stringTokenizer = new StringTokenizer(string2.substring(1));
            String string6 = string3;
            String string7 = stringTokenizer.nextToken();
            int n = Integer.valueOf(string7);
            if (stringTokenizer.hasMoreTokens()) {
                return null;
            }
            breakpointSpec = this.runtime.createClassLineBreakpoint(string6, n);
        } else {
            int n = string3.lastIndexOf(".");
            if (n <= 0 || n >= string3.length() - 1) {
                return null;
            }
            String string8 = string3.substring(n + 1);
            String string9 = string3.substring(0, n);
            ArrayList<String> arrayList = null;
            if (string2 != null) {
                if (!string2.startsWith("(") || !string2.endsWith(")")) {
                    return null;
                }
                string2 = string2.substring(1, string2.length() - 1);
                arrayList = new ArrayList<String>();
                stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            breakpointSpec = this.runtime.createMethodBreakpoint(string9, string8, arrayList);
        }
        return breakpointSpec;
    }

    private void commandStop(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listEventRequests();
        } else {
            BreakpointSpec breakpointSpec;
            String string = stringTokenizer.nextToken();
            if (string.equals("at") || string.equals("in")) {
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                } else {
                    this.env.error("Missing breakpoint specification.");
                    return;
                }
            }
            if ((breakpointSpec = this.parseBreakpointSpec(string)) != null) {
                this.runtime.install(breakpointSpec);
            } else {
                this.env.error("Ill-formed breakpoint specification.");
            }
        }
    }

    private void commandClear(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listEventRequests();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer.nextToken());
        if (breakpointSpec != null) {
            List<EventRequestSpec> list = this.runtime.eventRequestSpecs();
            if (list.isEmpty()) {
                this.env.notice("No breakpoints set.");
            } else {
                ArrayList<EventRequestSpec> arrayList = new ArrayList<EventRequestSpec>();
                for (EventRequestSpec eventRequestSpec : list) {
                    if (!eventRequestSpec.equals(breakpointSpec)) continue;
                    arrayList.add(eventRequestSpec);
                }
                if (arrayList.size() <= 1) {
                    this.env.notice("No matching breakpoint set.");
                }
                for (EventRequestSpec eventRequestSpec : arrayList) {
                    this.runtime.delete(eventRequestSpec);
                }
            }
        } else {
            this.env.error("Ill-formed breakpoint specification.");
        }
    }

    private void commandList(StringTokenizer stringTokenizer) throws NoSessionException {
        Object object;
        Location location;
        Object object2;
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.error("No thread specified.");
            return;
        }
        try {
            object2 = this.context.getCurrentFrame(threadReference);
            if (object2 == null) {
                this.env.failure("Thread has not yet begun execution.");
                return;
            }
            location = object2.location();
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        object2 = this.sourceManager.sourceForLocation(location);
        if (object2 == null) {
            if (location.method().isNative()) {
                this.env.failure("Current method is native.");
                return;
            }
            this.env.failure("No source available for " + Utils.locationString(location) + ".");
            return;
        }
        ReferenceType referenceType = location.declaringType();
        int n = location.lineNumber();
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = referenceType.methodsByName(string);
                if (object == null || object.size() == 0) {
                    this.env.failure(string + " is not a valid line number or " + "method name for class " + referenceType.name());
                    return;
                }
                if (object.size() > 1) {
                    this.env.failure(string + " is an ambiguous method name in" + referenceType.name());
                    return;
                }
                location = ((Method)object.get(0)).location();
                n = location.lineNumber();
            }
        }
        int n2 = n > 4 ? n - 4 : 1;
        int n3 = n2 + 9;
        object = ((SourceModel)object2).sourceLine(n);
        if (object == null) {
            this.env.failure("" + n + " is an invalid line number for " + referenceType.name());
        } else {
            OutputSink outputSink = this.env.getOutputSink();
            for (int i = n2; i <= n3 && (object = ((SourceModel)object2).sourceLine(i)) != null; ++i) {
                outputSink.print(i);
                outputSink.print("\t");
                if (i == n) {
                    outputSink.print("=> ");
                } else {
                    outputSink.print("   ");
                }
                outputSink.println((String)object);
            }
            outputSink.show();
        }
    }

    private void commandUse(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.sourceManager.getSourcePath().asString());
        } else {
            this.sourceManager.setSourcePath(new SearchPath(stringTokenizer.nextToken()));
        }
    }

    private void commandSourcepath(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.sourceManager.getSourcePath().asString());
        } else {
            this.sourceManager.setSourcePath(new SearchPath(stringTokenizer.nextToken()));
        }
    }

    private void commandClasspath(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.classManager.getClassPath().asString());
        } else {
            this.classManager.setClassPath(new SearchPath(stringTokenizer.nextToken()));
        }
    }

    private void commandView(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            String string = stringTokenizer.nextToken();
            if (string.endsWith(".java") || string.indexOf(File.separatorChar) >= 0) {
                this.env.viewSource(string);
            } else {
                String string2 = string.replace('.', File.separatorChar) + ".java";
                this.env.viewSource(string2);
            }
        }
    }

    private void commandLocals() throws NoSessionException {
        List<LocalVariable> list;
        StackFrame stackFrame;
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No default thread specified: use the \"thread\" command first.");
            return;
        }
        try {
            stackFrame = this.context.getCurrentFrame(threadReference);
            if (stackFrame == null) {
                this.env.failure("Thread has not yet created any stack frames.");
                return;
            }
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        try {
            list = stackFrame.visibleVariables();
            if (list == null || list.size() == 0) {
                this.env.failure("No local variables");
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            this.env.failure("Local variable information not available. Compile with -g to generate variable information");
            return;
        }
        OutputSink outputSink = this.env.getOutputSink();
        outputSink.println("Method arguments:");
        for (LocalVariable localVariable : list) {
            if (!localVariable.isArgument()) continue;
            this.printVar(outputSink, localVariable, stackFrame);
        }
        outputSink.println("Local variables:");
        for (LocalVariable localVariable : list) {
            if (localVariable.isArgument()) continue;
            this.printVar(outputSink, localVariable, stackFrame);
        }
        outputSink.show();
    }

    private void commandMonitor(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            this.env.getMonitorListModel().add(stringTokenizer.nextToken(""));
        }
    }

    private void commandUnmonitor(StringTokenizer stringTokenizer) throws NoSessionException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            this.env.getMonitorListModel().remove(stringTokenizer.nextToken(""));
        }
    }

    private void printVar(OutputSink outputSink, LocalVariable localVariable, StackFrame stackFrame) {
        outputSink.print("  " + localVariable.name());
        if (localVariable.isVisible(stackFrame)) {
            Value value = stackFrame.getValue(localVariable);
            outputSink.println(" = " + value.toString());
        } else {
            outputSink.println(" is not in scope");
        }
    }

    private void commandPrint(StringTokenizer stringTokenizer, boolean bl) throws NoSessionException {
        StackFrame stackFrame;
        if (!stringTokenizer.hasMoreTokens()) {
            this.env.error("No expression specified.");
            return;
        }
        ThreadReference threadReference = this.context.getCurrentThread();
        if (threadReference == null) {
            this.env.failure("No default thread specified: use the \"thread\" command first.");
            return;
        }
        try {
            stackFrame = this.context.getCurrentFrame(threadReference);
            if (stackFrame == null) {
                this.env.failure("Thread has not yet created any stack frames.");
                return;
            }
        }
        catch (VMNotInterruptedException vMNotInterruptedException) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken("");
            Value value = null;
            try {
                value = this.runtime.evaluate(stackFrame, string);
            }
            catch (Exception exception) {
                this.env.error("Exception: " + exception);
            }
            if (value == null) {
                return;
            }
            OutputSink outputSink = this.env.getOutputSink();
            if (bl && value instanceof ObjectReference && !(value instanceof StringReference)) {
                ObjectReference objectReference = (ObjectReference)value;
                ReferenceType referenceType = objectReference.referenceType();
                outputSink.println(string + " = " + value.toString() + " {");
                this.dump(outputSink, objectReference, referenceType, referenceType);
                outputSink.println("}");
            } else {
                outputSink.println(string + " = " + value.toString());
            }
            outputSink.show();
        }
    }

    private void dump(OutputSink outputSink, ObjectReference objectReference, ReferenceType referenceType, ReferenceType referenceType2) {
        for (Field comparable : referenceType.fields()) {
            outputSink.print("    ");
            if (!referenceType.equals(referenceType2)) {
                outputSink.print(referenceType.name() + ".");
            }
            outputSink.print(comparable.name() + ": ");
            Value value = objectReference.getValue(comparable);
            outputSink.println(value == null ? "null" : value.toString());
        }
        if (referenceType instanceof ClassType) {
            ClassType classType = ((ClassType)referenceType).superclass();
            if (classType != null) {
                this.dump(outputSink, objectReference, classType, referenceType2);
            }
        } else if (referenceType instanceof InterfaceType) {
            for (InterfaceType interfaceType : ((InterfaceType)referenceType).superinterfaces()) {
                this.dump(outputSink, objectReference, interfaceType, referenceType2);
            }
        }
    }

    private void help() {
        this.out.println("** command list **");
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("wherei [thread id] | all  -- dump a thread's stack, with pc info");
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup\n");
        this.out.println("dump <expression>         -- print all object information\n");
        this.out.println("locals                    -- print all local variables in current stack frame\n");
        this.out.println("classes                   -- list currently known classes");
        this.out.println("methods <class id>        -- list a class's methods\n");
        this.out.println("stop [in] <class id>.<method>[(argument_type,...)] -- set a breakpoint in a method");
        this.out.println("stop [at] <class id>:<line> -- set a breakpoint at a line");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("frame <frame-id>           -- to a frame");
        this.out.println("clear <class id>.<method>[(argument_type,...)]   -- clear a breakpoint in a method");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint at a line");
        this.out.println("clear                     -- list breakpoints");
        this.out.println("step                      -- execute current line");
        this.out.println("step up                   -- execute until the current method returns to its caller");
        this.out.println("stepi                     -- execute current instruction");
        this.out.println("next                      -- step one line (step OVER calls)");
        this.out.println("nexti                     -- step one instruction (step OVER calls)");
        this.out.println("cont                      -- continue execution from breakpoint\n");
        this.out.println("view classname|filename   -- display source file");
        this.out.println("list [line number|method] -- print source code context at line or method");
        this.out.println("use <source file path>    -- display or change the source path\n");
        this.out.println("sourcepath <source file path>    -- display or change the source path\n");
        this.out.println("classpath <class file path>    -- display or change the class path\n");
        this.out.println("monitor <expression>      -- evaluate an expression each time the program stops\n");
        this.out.println("unmonitor <monitor#>      -- delete a monitor\n");
        this.out.println("read <filename>           -- read and execute a command file\n");
        this.out.println("run <class> [args]        -- start execution of a Java class");
        this.out.println("run                       -- re-execute last class run");
        this.out.println("load <class> [args]       -- start execution of a Java class, initially suspended");
        this.out.println("load                      -- re-execute last class run, initially suspended");
        this.out.println("attach <portname>         -- debug existing process\n");
        this.out.println("detach                    -- detach from debuggee process\n");
        this.out.println("kill <thread(group)>      -- kill a thread or threadgroup\n");
        this.out.println("!!                        -- repeat last command");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("exit (or quit)            -- exit debugger");
    }

    public void executeCommand(String string) {
        block52: {
            this.out = this.env.getOutputSink();
            if (this.echo) {
                this.out.println(">>> " + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                String string2;
                if (stringTokenizer.hasMoreTokens()) {
                    this.lastCommand = string2 = stringTokenizer.nextToken().toLowerCase();
                } else {
                    string2 = this.lastCommand;
                }
                if (string2.equals("print")) {
                    this.commandPrint(stringTokenizer, false);
                    break block52;
                }
                if (string2.equals("eval")) {
                    this.commandPrint(stringTokenizer, false);
                    break block52;
                }
                if (string2.equals("dump")) {
                    this.commandPrint(stringTokenizer, true);
                    break block52;
                }
                if (string2.equals("locals")) {
                    this.commandLocals();
                    break block52;
                }
                if (string2.equals("classes")) {
                    this.commandClasses();
                    break block52;
                }
                if (string2.equals("methods")) {
                    this.commandMethods(stringTokenizer);
                    break block52;
                }
                if (string2.equals("threads")) {
                    this.commandThreads(stringTokenizer);
                    break block52;
                }
                if (string2.equals("thread")) {
                    this.commandThread(stringTokenizer);
                    break block52;
                }
                if (string2.equals("suspend")) {
                    this.commandSuspend(stringTokenizer);
                    break block52;
                }
                if (string2.equals("resume")) {
                    this.commandResume(stringTokenizer);
                    break block52;
                }
                if (string2.equals("cont")) {
                    this.commandCont();
                    break block52;
                }
                if (string2.equals("threadgroups")) {
                    this.commandThreadGroups();
                    break block52;
                }
                if (string2.equals("threadgroup")) {
                    this.commandThreadGroup(stringTokenizer);
                    break block52;
                }
                if (string2.equals("run")) {
                    this.commandRun(stringTokenizer);
                    break block52;
                }
                if (string2.equals("load")) {
                    this.commandLoad(stringTokenizer);
                    break block52;
                }
                if (string2.equals("connect")) {
                    this.commandConnect(stringTokenizer);
                    break block52;
                }
                if (string2.equals("attach")) {
                    this.commandAttach(stringTokenizer);
                    break block52;
                }
                if (string2.equals("detach")) {
                    this.commandDetach(stringTokenizer);
                    break block52;
                }
                if (string2.equals("interrupt")) {
                    this.commandInterrupt(stringTokenizer);
                    break block52;
                }
                if (string2.equals("step")) {
                    this.commandStep(stringTokenizer);
                    break block52;
                }
                if (string2.equals("stepi")) {
                    this.commandStepi();
                    break block52;
                }
                if (string2.equals("next")) {
                    this.commandNext();
                    break block52;
                }
                if (string2.equals("nexti")) {
                    this.commandNexti();
                    break block52;
                }
                if (string2.equals("kill")) {
                    this.commandKill(stringTokenizer);
                    break block52;
                }
                if (string2.equals("where")) {
                    this.commandWhere(stringTokenizer, false);
                    break block52;
                }
                if (string2.equals("wherei")) {
                    this.commandWhere(stringTokenizer, true);
                    break block52;
                }
                if (string2.equals("up")) {
                    this.commandUp(stringTokenizer);
                    break block52;
                }
                if (string2.equals("down")) {
                    this.commandDown(stringTokenizer);
                    break block52;
                }
                if (string2.equals("frame")) {
                    this.commandFrame(stringTokenizer);
                    break block52;
                }
                if (string2.equals("stop")) {
                    this.commandStop(stringTokenizer);
                    break block52;
                }
                if (string2.equals("clear")) {
                    this.commandClear(stringTokenizer);
                    break block52;
                }
                if (string2.equals("list")) {
                    this.commandList(stringTokenizer);
                    break block52;
                }
                if (string2.equals("use")) {
                    this.commandUse(stringTokenizer);
                    break block52;
                }
                if (string2.equals("sourcepath")) {
                    this.commandSourcepath(stringTokenizer);
                    break block52;
                }
                if (string2.equals("classpath")) {
                    this.commandClasspath(stringTokenizer);
                    break block52;
                }
                if (string2.equals("monitor")) {
                    this.commandMonitor(stringTokenizer);
                    break block52;
                }
                if (string2.equals("unmonitor")) {
                    this.commandUnmonitor(stringTokenizer);
                    break block52;
                }
                if (string2.equals("view")) {
                    this.commandView(stringTokenizer);
                    break block52;
                }
                if (string2.equals("help") || string2.equals("?")) {
                    this.help();
                    break block52;
                }
                if (string2.equals("quit") || string2.equals("exit")) {
                    try {
                        this.runtime.detach();
                    }
                    catch (NoSessionException noSessionException) {
                        // empty catch block
                    }
                    this.env.terminate();
                    break block52;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        int n = Integer.parseInt(string2);
                        String string3 = stringTokenizer.nextToken("");
                        while (n-- > 0) {
                            this.executeCommand(string3);
                        }
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.out.println("huh? Try help...");
                this.out.flush();
            }
            catch (NoSessionException noSessionException) {
                this.out.println("There is no currently attached VM session.");
                this.out.flush();
            }
            catch (Exception exception) {
                this.out.println("Internal exception: " + exception.toString());
                this.out.flush();
                System.out.println("JDB internal exception: " + exception.toString());
                exception.printStackTrace();
            }
        }
        this.out.show();
    }
}

