/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.HKSCS;
import sun.nio.cs.ext.MS950;

public class MS950_HKSCS
extends Charset
implements HistoricallyNamedCharset {
    public MS950_HKSCS() {
        super("x-MS950-HKSCS", ExtendedCharsets.aliasesFor("x-MS950-HKSCS"));
    }

    @Override
    public String historicalName() {
        return "MS950_HKSCS";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS950 || charset instanceof MS950_HKSCS;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends HKSCS.Encoder {
        private static DoubleByte.Encoder ms950Enc = (DoubleByte.Encoder)new MS950().newEncoder();

        @Override
        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            return n != 65533 ? n : ms950Enc.encodeChar(c);
        }

        private Encoder(Charset charset) {
            super(charset);
        }
    }

    private static class Decoder
    extends HKSCS.Decoder {
        private static DoubleByte.Decoder ms950Dec = (DoubleByte.Decoder)new MS950().newDecoder();

        @Override
        protected char decodeDouble(int n, int n2) {
            char c = super.decodeDouble(n, n2);
            return c != '\ufffd' ? c : ms950Dec.decodeDouble(n, n2);
        }

        private Decoder(Charset charset) {
            super(charset);
        }
    }
}

