/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import sun.jvm.hotspot.ui.Editor;
import sun.jvm.hotspot.ui.EditorCommands;
import sun.jvm.hotspot.ui.GraphicsUtilities;

public class SourceCodePanel
extends JPanel {
    private JTextArea source;
    private RowHeader header;
    private String filename;
    private static final int LINE_NO_SPACE = 4;
    private static final int ICON_SIZE = 12;
    private static Icon topFrameCurLine;
    private static Icon lowerFrameCurLine;
    private static Icon breakpoint;
    private int highlightedLine = -1;
    private Set breakpoints = new HashSet();
    private EditorCommands comm;
    private Editor parent;

    public SourceCodePanel() {
        this.maybeLoadIcons();
        this.setLayout(new BorderLayout());
        this.source = new JTextArea();
        this.source.setEditable(false);
        this.source.getCaret().setVisible(true);
        this.header = new RowHeader();
        this.header.setShowLineNumbers(true);
        JScrollPane scroller = new JScrollPane(this.source);
        JViewport rowView = new JViewport();
        rowView.setView(this.header);
        this.header.setViewport(rowView);
        rowView.setScrollMode(0);
        scroller.setRowHeader(rowView);
        this.add((Component)scroller, "Center");
        this.setFont(this.getFont());
        this.source.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SourceCodePanel.this.source.getCaret().setVisible(true);
            }
        });
        this.source.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 120) {
                    int lineNo = SourceCodePanel.this.getCurrentLineNumber();
                    SourceCodePanel.this.comm.toggleBreakpointAtLine(SourceCodePanel.this.parent, lineNo);
                }
            }
        });
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.source != null) {
            this.source.setFont(f);
        }
        if (this.header != null) {
            this.header.setFont(f);
        }
    }

    public boolean getShowLineNumbers() {
        return this.header.getShowLineNumbers();
    }

    public void setShowLineNumbers(boolean val) {
        this.header.setShowLineNumbers(val);
    }

    public boolean openFile(String filename) {
        try {
            this.filename = filename;
            File file = new File(filename);
            int len = (int)file.length();
            StringBuffer buf = new StringBuffer(len);
            char[] tmp = new char[4096];
            FileReader in = new FileReader(file);
            int res = 0;
            do {
                if ((res = in.read(tmp, 0, tmp.length)) < 0) continue;
                buf.append(tmp, 0, res);
            } while (res != -1);
            in.close();
            String text = buf.toString();
            this.source.setText(text);
            this.header.recomputeSize();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getSourceFileName() {
        return this.filename;
    }

    public int getCurrentLineNumber() {
        try {
            return 1 + this.source.getLineOfOffset(this.source.getCaretPosition());
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    public void showLineNumber(int lineNo) {
        try {
            int offset = this.source.getLineStartOffset(lineNo - 1);
            Rectangle rect = this.source.modelToView(offset);
            if (rect == null) {
                return;
            }
            this.source.scrollRectToVisible(rect);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void highlightLineNumber(int lineNo) {
        this.highlightedLine = lineNo - 1;
    }

    public void showBreakpointAtLine(int lineNo) {
        this.breakpoints.add(new Integer(lineNo - 1));
        this.repaint();
    }

    public boolean hasBreakpointAtLine(int lineNo) {
        return this.breakpoints.contains(new Integer(lineNo - 1));
    }

    public void clearBreakpointAtLine(int lineNo) {
        this.breakpoints.remove(new Integer(lineNo - 1));
        this.repaint();
    }

    public void clearBreakpoints() {
        this.breakpoints.clear();
        this.repaint();
    }

    public void setEditorCommands(EditorCommands comm, Editor parent) {
        this.comm = comm;
        this.parent = parent;
    }

    public void requestFocus() {
        this.source.requestFocus();
    }

    private void maybeLoadIcons() {
        if (topFrameCurLine == null) {
            topFrameCurLine = this.loadIcon("resources/arrow.png");
            lowerFrameCurLine = this.loadIcon("resources/triangle.png");
            breakpoint = this.loadIcon("resources/breakpoint.png");
        }
    }

    private Icon loadIcon(String which) {
        URL url = this.getClass().getResource(which);
        return new ImageIcon(url);
    }

    class RowHeader
    extends JPanel {
        private JViewport view;
        private boolean showLineNumbers;
        private int width;
        private int rowHeight;
        private boolean initted = true;

        public RowHeader() {
            this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

                public void ancestorResized(HierarchyEvent e) {
                    RowHeader.this.recomputeSize();
                }
            });
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.getShowLineNumbers()) {
                Rectangle clip = g.getClipBounds();
                int start = clip.y / this.rowHeight;
                int end = start + (clip.height + (this.rowHeight - 1)) / this.rowHeight;
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int ascent = fm.getMaxAscent();
                for (int i = start; i <= end; ++i) {
                    String str = Integer.toString(i + 1);
                    int strWidth = GraphicsUtilities.getStringWidth(str, fm);
                    g.drawString(str, this.width - strWidth - 4, ascent + this.rowHeight * i);
                    if (SourceCodePanel.this.breakpoints.contains(new Integer(i))) {
                        breakpoint.paintIcon(this, g, 4, this.rowHeight * i);
                    }
                    if (i != SourceCodePanel.this.highlightedLine) continue;
                    topFrameCurLine.paintIcon(this, g, 4, this.rowHeight * i);
                }
            }
        }

        public boolean getShowLineNumbers() {
            return this.showLineNumbers;
        }

        public void setShowLineNumbers(boolean val) {
            if (val != this.showLineNumbers) {
                this.showLineNumbers = val;
                this.recomputeSize();
                this.invalidate();
                this.validate();
            }
        }

        public void setFont(Font f) {
            super.setFont(f);
            this.rowHeight = this.getFontMetrics(f).getHeight();
            this.recomputeSize();
        }

        void setViewport(JViewport view) {
            this.view = view;
        }

        void recomputeSize() {
            if (!this.initted) {
                return;
            }
            if (this.view == null) {
                return;
            }
            this.width = 20;
            try {
                int numLines = 1 + SourceCodePanel.this.source.getLineOfOffset(SourceCodePanel.this.source.getDocument().getEndPosition().getOffset() - 1);
                String str = Integer.toString(numLines);
                if (this.getShowLineNumbers()) {
                    this.width += GraphicsUtilities.getStringWidth(str, this.getFontMetrics(this.getFont())) + 4;
                }
                Dimension d = new Dimension(this.width, numLines * this.getFontMetrics(this.getFont()).getHeight());
                this.setSize(d);
                this.setPreferredSize(d);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

