/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjectHistogramElement;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;

public class FinalizerInfo
extends Tool {
    public static void main(String[] args) {
        FinalizerInfo finfo = new FinalizerInfo();
        finfo.start(args);
        finfo.stop();
    }

    public void run() {
        InstanceKlass ik = SystemDictionaryHelper.findInstanceKlass("java.lang.ref.Finalizer");
        final OopField[] queueField = new OopField[1];
        ik.iterateFields(new DefaultOopVisitor(){

            public void doOop(OopField field, boolean isVMField) {
                String name = field.getID().getName();
                if (name.equals("queue")) {
                    queueField[0] = field;
                }
            }
        }, false);
        Oop queue = queueField[0].getValue(ik);
        InstanceKlass k = (InstanceKlass)queue.getKlass();
        LongField queueLengthField = (LongField)k.findField("queueLength", "J");
        long queueLength = queueLengthField.getValue(queue);
        OopField headField = (OopField)k.findField("head", "Ljava/lang/ref/Reference;");
        Oop head = headField.getValue(queue);
        System.out.println("Number of objects pending for finalization: " + queueLength);
        if (head != null) {
            k = (InstanceKlass)head.getKlass();
            OopField referentField = (OopField)k.findField("referent", "Ljava/lang/Object;");
            OopField nextField = (OopField)k.findField("next", "Ljava/lang/ref/Reference;");
            HashMap<Klass, ObjectHistogramElement> map = new HashMap<Klass, ObjectHistogramElement>();
            while (true) {
                Oop referent;
                Klass klass;
                if (!map.containsKey(klass = (referent = referentField.getValue(head)).getKlass())) {
                    map.put(klass, new ObjectHistogramElement(klass));
                }
                ((ObjectHistogramElement)map.get(klass)).updateWith(referent);
                Oop next = nextField.getValue(head);
                if (next == null || next.equals(head)) break;
                head = next;
            }
            ArrayList list = new ArrayList();
            list.addAll(map.values());
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ObjectHistogramElement)o1).compare((ObjectHistogramElement)o2);
                }
            });
            System.out.println("");
            System.out.println("Count\tClass description");
            System.out.println("-------------------------------------------------------");
            for (int i = 0; i < list.size(); ++i) {
                ObjectHistogramElement e = (ObjectHistogramElement)list.get(i);
                System.out.println(e.getCount() + "\t" + e.getDescription());
            }
        }
    }
}

