/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class FreeList
extends VMObject {
    private static CIntegerField sizeField;
    private static CIntegerField countField;
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("FreeList");
        sizeField = type.getCIntegerField("_size");
        countField = type.getCIntegerField("_count");
        headerSize = type.getSize();
    }

    public FreeList(Address address) {
        super(address);
    }

    public long size() {
        return sizeField.getValue(this.addr);
    }

    public long count() {
        return countField.getValue(this.addr);
    }

    public static long sizeOf() {
        return headerSize;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                FreeList.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

