/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.ArithmeticInstruction;
import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.sparc.SPARCFormat3AInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCArithmeticInstruction
extends SPARCFormat3AInstruction
implements ArithmeticInstruction {
    private final int operation;

    public SPARCArithmeticInstruction(String name, int opcode, int operation, SPARCRegister rs1, ImmediateOrRegister operand2, SPARCRegister rd) {
        super(name, opcode, rs1, operand2, rd);
        this.operation = operation;
    }

    protected String getDescription() {
        if (this.rd == this.rs1 && this.operand2.isImmediate()) {
            int value = ((Immediate)this.operand2).getNumber().intValue();
            StringBuffer buf = new StringBuffer();
            switch (this.opcode) {
                case 0: {
                    buf.append("inc");
                    break;
                }
                case 16: {
                    buf.append("inccc");
                    break;
                }
                case 4: {
                    buf.append("dec");
                    break;
                }
                case 20: {
                    buf.append("deccc");
                    break;
                }
                default: {
                    return super.getDescription();
                }
            }
            buf.append(spaces);
            if (value != 1) {
                buf.append(this.getOperand2String());
                buf.append(comma);
            }
            buf.append(this.rd.toString());
            return buf.toString();
        }
        if (this.rd == SPARCRegisters.G0 && this.opcode == 20) {
            StringBuffer buf = new StringBuffer();
            buf.append("cmp");
            buf.append(spaces);
            buf.append(this.rs1.toString());
            buf.append(comma);
            buf.append(this.getOperand2String());
            return buf.toString();
        }
        if (this.rs1 == SPARCRegisters.G0 && this.opcode == 4 && this.operand2.isRegister()) {
            StringBuffer buf = new StringBuffer();
            buf.append("neg");
            buf.append(spaces);
            buf.append(this.operand2.toString());
            if (this.operand2 != this.rd) {
                buf.append(comma);
                buf.append(this.rd.toString());
            }
            return buf.toString();
        }
        return super.getDescription();
    }

    public Operand getArithmeticDestination() {
        return this.getDestinationRegister();
    }

    public Operand[] getArithmeticSources() {
        return new Operand[]{this.rs1, this.operand2};
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isArithmetic() {
        return true;
    }
}

