/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsEdit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;

public class EditorInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorInfo");
    @NonNls
    private static final String FORMAT = "EEE MMM dd HH:mm:ss yyyy zzz";
    public static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy zzz", Locale.US));
    @NonNls
    private static final String FORMAT1 = "dd MMM yyyy HH:mm:ss zzz";
    public static final SyncDateFormat DATE_FORMAT1 = new SyncDateFormat((DateFormat)new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz", Locale.US));
    private final String myFilePath;
    private final String myUserName;
    private final Date myEditDate;
    private final String myHostHame;
    private final String myPath;

    public static EditorInfo createOn(String string) {
        String[] strings = string.split("\t");
        if (strings.length != 5) {
            return null;
        }
        return new EditorInfo(strings[0], strings[1], EditorInfo.parse(strings[2]), strings[3], strings[4]);
    }

    private EditorInfo(String filePath, String userName, Date editDate, String hostHame, String path) {
        this.myFilePath = filePath;
        this.myUserName = userName;
        this.myEditDate = editDate;
        this.myHostHame = hostHame;
        this.myPath = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditorInfo)) {
            return false;
        }
        EditorInfo editorInfo = (EditorInfo)o;
        if (!this.myEditDate.equals(editorInfo.myEditDate)) {
            return false;
        }
        if (!this.myHostHame.equals(editorInfo.myHostHame)) {
            return false;
        }
        if (!this.myPath.equals(editorInfo.myPath)) {
            return false;
        }
        return this.myUserName.equals(editorInfo.myUserName);
    }

    public int hashCode() {
        int result = this.myUserName.hashCode();
        result = 29 * result + this.myEditDate.hashCode();
        result = 29 * result + this.myHostHame.hashCode();
        result = 29 * result + this.myPath.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.myUserName);
        result.append('\t');
        result.append(DATE_FORMAT.format(this.myEditDate));
        result.append('\t');
        result.append(this.myHostHame);
        result.append('\t');
        result.append(this.myPath);
        result.append('\t');
        return result.toString();
    }

    public String getUserName() {
        return this.myUserName;
    }

    public String getHostHame() {
        return this.myHostHame;
    }

    public String getPath() {
        return this.myPath;
    }

    public Date getEditDate() {
        return this.myEditDate;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public static Date parse(String s) {
        try {
            return DATE_FORMAT.parse(s);
        }
        catch (ParseException e) {
            try {
                return DATE_FORMAT1.parse(s);
            }
            catch (ParseException e1) {
                LOG.error((Throwable)e1);
                return new Date();
            }
        }
    }
}

