/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.actions.cvsContext.CvsDataKeys;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.changeBrowser.CvsRepositoryLocation;
import com.intellij.cvsSupport2.checkout.CheckoutAction;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CheckoutHelper;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsTree;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeUIHelper;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class BrowserPanel
extends JPanel
implements DataProvider,
CvsTabbedWindow.DeactivateListener {
    private final CvsTree myTree;
    private final CheckoutHelper myCheckoutHelper;
    private final CvsRootConfiguration myCvsRootConfiguration;
    private final Project myProject;

    public BrowserPanel(CvsRootConfiguration configuration, Project project) {
        super(new BorderLayout(2, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.myProject = project;
        this.myCvsRootConfiguration = configuration;
        this.myTree = new CvsTree(configuration, project, true, 1, false, true);
        this.add((Component)this.myTree, "Center");
        this.myTree.init();
        this.myCheckoutHelper = new CheckoutHelper(configuration, this);
        TreeUIHelper uiHelper = TreeUIHelper.getInstance();
        uiHelper.installToolTipHandler(this.myTree.getTree());
        uiHelper.installEditSourceOnDoubleClick(this.myTree.getTree());
        TreeUtil.installActions((JTree)this.myTree.getTree());
        ActionGroup group = this.getActionGroup();
        PopupHandler.installPopupHandler((JComponent)this.myTree.getTree(), (ActionGroup)group, (String)"CheckoutPopup", (ActionManager)ActionManager.getInstance());
    }

    public ActionGroup getActionGroup() {
        DefaultActionGroup result = new DefaultActionGroup();
        result.add((AnAction)new EditSourceAction());
        result.add((AnAction)new MyCheckoutAction());
        result.add((AnAction)new MyAnnotateAction());
        result.add((AnAction)new BrowseChangesAction());
        return result;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile cvsVirtualFile = this.getCvsVirtualFile();
            if (cvsVirtualFile == null || !cvsVirtualFile.isValid()) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, cvsVirtualFile);
        }
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CvsDataKeys.CVS_ENVIRONMENT.is(dataId)) {
            return this.myCvsRootConfiguration;
        }
        if (CvsDataKeys.CVS_LIGHT_FILE.is(dataId)) {
            return this.getCvsLightFile();
        }
        return null;
    }

    @Nullable
    private VirtualFile getCvsVirtualFile() {
        CvsElement[] currentSelection = this.myTree.getCurrentSelection();
        if (currentSelection.length != 1) {
            return null;
        }
        VirtualFile file = currentSelection[0].getVirtualFile();
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return file;
    }

    @Nullable
    private CvsLightweightFile getCvsLightFile() {
        CvsElement[] currentSelection = this.myTree.getCurrentSelection();
        if (currentSelection.length != 1) {
            return null;
        }
        return new CvsLightweightFile(currentSelection[0].getCvsLightFile(), null);
    }

    @Override
    public void deactivated() {
        this.myTree.deactivated();
    }

    private class BrowseChangesAction
    extends AnAction {
        public BrowseChangesAction() {
            super(VcsBundle.message((String)"browse.changes.action", (Object[])new Object[0]), "", IconLoader.getIcon((String)"/actions/showChangesOnly.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            assert (currentSelection.length == 1);
            String moduleName = currentSelection[0].getElementPath();
            CvsRepositoryLocation location = new CvsRepositoryLocation(null, BrowserPanel.this.myCvsRootConfiguration, moduleName);
            AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showChangesBrowser(CvsVcs2.getInstance(BrowserPanel.this.myProject).getCommittedChangesProvider(), (RepositoryLocation)location, VcsBundle.message((String)"browse.changes.scope", (Object[])new Object[]{moduleName}), (Component)BrowserPanel.this);
        }

        public void update(AnActionEvent e) {
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            e.getPresentation().setEnabled(currentSelection.length == 1);
        }
    }

    private class MyAnnotateAction
    extends AnAction {
        public MyAnnotateAction() {
            super(CvsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/annotate.png"));
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(true);
            CvsLightweightFile cvsLightFile = BrowserPanel.this.getCvsLightFile();
            if (cvsLightFile != null) {
                File file = cvsLightFile.getCvsFile();
                presentation.setEnabled(file != null);
            } else {
                presentation.setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            VcsVirtualFile vcsVirtualFile = (VcsVirtualFile)BrowserPanel.this.getCvsVirtualFile();
            try {
                FileAnnotation annotation = CvsVcs2.getInstance(BrowserPanel.this.myProject).createAnnotation((VirtualFile)vcsVirtualFile, vcsVirtualFile.getRevision(), BrowserPanel.this.myCvsRootConfiguration);
                AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showAnnotation(annotation, (VirtualFile)vcsVirtualFile);
            }
            catch (VcsException e1) {
                AbstractVcsHelper.getInstance((Project)BrowserPanel.this.myProject).showError(e1, CvsBundle.message((String)"operation.name.annotate", (Object[])new Object[0]));
            }
        }
    }

    private class MyCheckoutAction
    extends AnAction {
        public MyCheckoutAction() {
            super(CvsBundle.message((String)"operation.name.check.out", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/checkOut.png"));
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.canPerformCheckout());
        }

        private boolean canPerformCheckout() {
            CvsElement[] currentSelection = BrowserPanel.this.myTree.getCurrentSelection();
            return currentSelection.length == 1 && currentSelection[0].canBeCheckedOut();
        }

        public void actionPerformed(AnActionEvent e) {
            CvsElement[] cvsElements = BrowserPanel.this.myTree.getCurrentSelection();
            CvsElement selectedElement = cvsElements[0];
            if (!BrowserPanel.this.myCheckoutHelper.prepareCheckoutData(selectedElement, false, null)) {
                return;
            }
            CvsHandler checkoutHandler = CommandCvsHandler.createCheckoutHandler(BrowserPanel.this.myCvsRootConfiguration, new String[]{selectedElement.getCheckoutPath()}, BrowserPanel.this.myCheckoutHelper.getCheckoutLocation(), false, CvsConfiguration.getInstance((Project)((BrowserPanel)BrowserPanel.this).myProject).MAKE_NEW_FILES_READONLY, VcsConfiguration.getInstance((Project)BrowserPanel.this.myProject).getCheckoutOption());
            CvsContextAdapter context = new CvsContextAdapter(){

                @Override
                public Project getProject() {
                    return BrowserPanel.this.myProject;
                }
            };
            new CheckoutAction(new CvsElement[]{selectedElement}, BrowserPanel.this.myCheckoutHelper.getCheckoutLocation(), false).actionPerformed(context, checkoutHandler);
        }
    }

    private static class EditSourceAction
    extends AnAction {
        public EditSourceAction() {
            super(ActionsBundle.actionText((String)"EditSource"), ActionsBundle.actionDescription((String)"EditSource"), IconLoader.getIcon((String)"/actions/editSource.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            Navigatable[] navigatableArray = (Navigatable[])e.getData(PlatformDataKeys.NAVIGATABLE_ARRAY);
            if (navigatableArray != null && navigatableArray.length > 0) {
                OpenSourceUtil.navigate((Navigatable[])navigatableArray, (boolean)true);
            }
        }

        public void update(AnActionEvent e) {
            Navigatable[] navigatableArray = (Navigatable[])e.getData(PlatformDataKeys.NAVIGATABLE_ARRAY);
            e.getPresentation().setEnabled(navigatableArray != null && navigatableArray.length > 0);
        }
    }
}

