/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SynchronizedMethodInspection
extends BaseInspection {
    public boolean m_includeNativeMethods = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronized.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizedMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("synchronized.method.problem.descriptor", method.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizedMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        if (method.getBody() == null) {
            return null;
        }
        return new SynchronizedMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizedMethodVisitor();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("synchronized.method.include.option", new Object[0]), (InspectionProfileEntry)this, "m_includeNativeMethods");
    }

    private class SynchronizedMethodVisitor
    extends BaseInspectionVisitor {
        private SynchronizedMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodVisitor.visitMethod must not be null");
            }
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            if (!SynchronizedMethodInspection.this.m_includeNativeMethods && method.hasModifierProperty("native")) {
                return;
            }
            this.registerModifierError("synchronized", (PsiModifierListOwner)method, method);
        }
    }

    private static class SynchronizedMethodFix
    extends InspectionGadgetsFix {
        private SynchronizedMethodFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("synchronized.method.move.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizedMethodInspection$SynchronizedMethodFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String replacementText;
            PsiElement nameElement = descriptor.getPsiElement();
            PsiModifierList modiferList = (PsiModifierList)nameElement.getParent();
            assert (modiferList != null);
            PsiMethod method = (PsiMethod)modiferList.getParent();
            modiferList.setModifierProperty("synchronized", false);
            assert (method != null);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            String text = body.getText();
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass = method.getContainingClass();
                assert (containingClass != null);
                String className = containingClass.getName();
                replacementText = "{ synchronized(" + className + ".class){" + text.substring(1) + '}';
            } else {
                replacementText = "{ synchronized(this){" + text.substring(1) + '}';
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiCodeBlock block = elementFactory.createCodeBlockFromText(replacementText, null);
            body.replace((PsiElement)block);
            CodeStyleManager codeStyleManager = psiManager.getCodeStyleManager();
            codeStyleManager.reformat((PsiElement)method);
        }
    }
}

