/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIndexOfReplaceableByContainsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("indexof.replaceable.by.contains.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String text;
        PsiBinaryExpression expression = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = expression.getLOperand();
        PsiJavaToken sign = expression.getOperationSign();
        if (lhs instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            text = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, sign, false);
        } else {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression.getROperand();
            assert (callExpression != null);
            text = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, sign, true);
        }
        String string = InspectionGadgetsBundle.message("indexof.replaceable.by.contains.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IndexOfReplaceableByContainsFix();
    }

    static String createContainsExpressionText(@NotNull PsiMethodCallExpression call, @NotNull PsiJavaToken sign, boolean flipped) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection.createContainsExpressionText must not be null");
        }
        if (sign == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection.createContainsExpressionText must not be null");
        }
        IElementType tokenType = sign.getTokenType();
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        String qualifierText = qualifierExpression == null ? "" : qualifierExpression.getText();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression expression = argumentList.getExpressions()[0];
        String newExpressionText = qualifierText + ".contains(" + expression.getText() + ')';
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return '!' + newExpressionText;
        }
        if (!flipped && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE))) {
            return '!' + newExpressionText;
        }
        if (flipped && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE))) {
            return '!' + newExpressionText;
        }
        return newExpressionText;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends BaseInspectionVisitor {
        private IndexOfReplaceableByContainsVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiJavaToken sign;
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiJavaToken sign2 = expression.getOperationSign();
                if (IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(lhs, sign2, rhs, false)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (rhs instanceof PsiMethodCallExpression && IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(rhs, sign = expression.getOperationSign(), lhs, true)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean canBeReplacedByContains(PsiExpression lhs, PsiJavaToken sign, PsiExpression rhs, boolean flipped) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!IndexOfReplaceableByContainsVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            IElementType tokenType = sign.getTokenType();
            if (flipped) {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.LT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.GE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType))) {
                    return true;
                }
            } else {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.LE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.GE.equals(tokenType) || JavaTokenType.LT.equals(tokenType))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsVisitor.isIndexOfCall must not be null");
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"indexOf".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            Project project = expression.getProject();
            GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass javaUtilListClass = psiFacade.findClass("java.util.List", projectScope);
            if (javaUtilListClass == null) {
                return false;
            }
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiClassType javaUtilListType = factory.createType(javaUtilListClass);
            return javaUtilListType.isAssignableFrom(qualifierType);
        }
    }

    private static class IndexOfReplaceableByContainsFix
    extends InspectionGadgetsFix {
        private IndexOfReplaceableByContainsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String newExpressionText;
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            PsiJavaToken sign = expression.getOperationSign();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, sign, false);
            } else {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)rhs;
                assert (callExpression != null);
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, sign, true);
            }
            IndexOfReplaceableByContainsFix.replaceExpression((PsiExpression)expression, newExpressionText);
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.indexof.with.contains.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix.getName must not return null");
            }
            return string;
        }
    }
}

