/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeSerializableFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonSerializableClassWithSerializationMethods" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.getID must not return null");
        }
        return "NonSerializableClassWithSerializationMethods";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos[2] instanceof PsiAnonymousClass) {
            return null;
        }
        return new MakeSerializableFix();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        PsiClass aClass = (PsiClass)infos[2];
        if (aClass instanceof PsiAnonymousClass) {
            if (!(hasReadObject && hasWriteObject ? (string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.both", new Object[0])) != null : (hasWriteObject ? (string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.write", new Object[0])) != null : (string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.read", new Object[0])) != null))) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        if (hasReadObject && hasWriteObject) {
            string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.both", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        if (hasWriteObject) {
            string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.write", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.read", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonserializableDefinesSerializationMethodsVisitor();
    }

    private static class NonserializableDefinesSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private NonserializableDefinesSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection$NonserializableDefinesSerializationMethodsVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject, aClass);
        }
    }
}

