/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.imports.ImportsAreUsedVisitor;
import com.siyeh.ig.imports.StaticImportsAreUsedVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedImportInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/UnusedImportInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/UnusedImportInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedImportVisitor();
    }

    private static class UnusedImportVisitor
    extends BaseInspectionVisitor {
        private UnusedImportVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file) {
            if (JspPsiUtil.isInJspFile((PsiElement)file)) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            PsiClass[] classes = file.getClasses();
            PsiPackageStatement packageStatement = file.getPackageStatement();
            PsiModifierList annotationList = packageStatement != null ? packageStatement.getAnnotationList() : null;
            PsiImportStatement[] importStatements = importList.getImportStatements();
            this.checkImports(importStatements, classes, annotationList);
            PsiImportStaticStatement[] importStaticStatements = importList.getImportStaticStatements();
            this.checkStaticImports(importStaticStatements, classes);
        }

        private void checkStaticImports(PsiImportStaticStatement[] importStaticStatements, PsiClass[] classes) {
            PsiImportStaticStatement[] unusedImportStaticStatements;
            if (importStaticStatements.length == 0) {
                return;
            }
            StaticImportsAreUsedVisitor visitor = new StaticImportsAreUsedVisitor(importStaticStatements);
            for (PsiClass aClass : classes) {
                aClass.accept((PsiElementVisitor)visitor);
            }
            for (PsiImportStaticStatement importStaticStatement : unusedImportStaticStatements = visitor.getUnusedImportStaticStatements()) {
                this.registerError((PsiElement)importStaticStatement, new Object[0]);
            }
        }

        private void checkImports(PsiImportStatement[] importStatements, PsiClass[] classes, @Nullable PsiModifierList annotationList) {
            PsiImportStatement[] unusedImportStatements;
            if (importStatements.length == 0) {
                return;
            }
            ImportsAreUsedVisitor visitor = new ImportsAreUsedVisitor(importStatements);
            for (PsiClass aClass : classes) {
                aClass.accept((PsiElementVisitor)visitor);
            }
            if (annotationList != null) {
                annotationList.accept((PsiElementVisitor)visitor);
            }
            for (PsiImportStatement unusedImportStatement : unusedImportStatements = visitor.getUnusedImportStatements()) {
                this.registerError((PsiElement)unusedImportStatement, new Object[0]);
            }
        }
    }
}

