/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopeUtils {
    private ScopeUtils() {
    }

    @Nullable
    public static PsiElement findTighterDeclarationLocation(@NotNull PsiElement sibling, @NotNull PsiVariable variable) {
        if (sibling == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.findTighterDeclarationLocation must not be null");
        }
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.findTighterDeclarationLocation must not be null");
        }
        PsiElement prevSibling = sibling.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof PsiDeclarationStatement) {
            if (prevSibling.equals(variable.getParent())) {
                return null;
            }
            return ScopeUtils.findTighterDeclarationLocation(prevSibling, variable);
        }
        return prevSibling;
    }

    @Nullable
    public static PsiElement getChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.getChildWhichContainsElement must not be null");
        }
        if (descendant == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.getChildWhichContainsElement must not be null");
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    @Nullable
    public static PsiElement getCommonParent(@NotNull PsiElement[] referenceElements) {
        PsiElement parent;
        if (referenceElements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.getCommonParent must not be null");
        }
        Arrays.sort(referenceElements, PsiElementOrderComparator.getInstance());
        PsiElement commonParent = null;
        for (PsiElement referenceElement : referenceElements) {
            PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)referenceElement, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            if (parent2 != null && commonParent != null) {
                if (commonParent.equals(parent2)) continue;
                commonParent = PsiTreeUtil.findCommonParent((PsiElement)commonParent, (PsiElement)parent2);
                commonParent = ScopeUtils.getNonStrictParentOfType(commonParent, PsiCodeBlock.class, PsiForStatement.class);
                continue;
            }
            commonParent = parent2;
        }
        if (commonParent instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)commonParent;
            PsiElement referenceElement = referenceElements[0];
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiEmptyStatement)) {
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)initialization;
                    PsiExpression expression = statement.getExpression();
                    if (expression instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                        PsiExpression lExpression = assignmentExpression.getLExpression();
                        if (!lExpression.equals(referenceElement)) {
                            commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                        }
                    } else {
                        commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                    }
                } else {
                    commonParent = PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class);
                }
            }
        }
        if (commonParent != null && (parent = commonParent.getParent()) instanceof PsiSwitchStatement && referenceElements.length > 1) {
            commonParent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
        }
        return commonParent;
    }

    @Nullable
    public static PsiElement getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends PsiElement> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.getNonStrictParentOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        while (element != null) {
            for (Class<? extends PsiElement> clazz : classes) {
                if (!clazz.isInstance(element)) continue;
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement moveOutOfLoops(@NotNull PsiElement scope, @NotNull PsiElement maxScope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.moveOutOfLoops must not be null");
        }
        if (maxScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ScopeUtils.moveOutOfLoops must not be null");
        }
        PsiElement result = maxScope;
        if (result instanceof PsiLoopStatement) {
            return result;
        }
        while (!result.equals(scope)) {
            PsiElement element = ScopeUtils.getChildWhichContainsElement(result, scope);
            if (element == null || element instanceof PsiLoopStatement) {
                while (result != null && !(result instanceof PsiCodeBlock)) {
                    result = result.getParent();
                }
                return result;
            }
            result = element;
        }
        return scope;
    }
}

