/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassWithoutPrivateConstructorInspection
extends BaseInspection {
    public boolean ignoreClassesWithOnlyMain = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("utility.class.without.private.constructor.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassesWithOnlyMain");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        PsiMethod constructor = UtilityClassWithoutPrivateConstructorInspection.getNullArgConstructor(aClass);
        if (constructor == null) {
            return new CreateEmptyPrivateConstructor();
        }
        Query query = ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope());
        PsiReference reference = (PsiReference)query.findFirst();
        if (reference == null) {
            return new MakeConstructorPrivateFix();
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassWithoutPrivateConstructorVisitor();
    }

    @Nullable
    static PsiMethod getNullArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiParameterList params = constructor.getParameterList();
            if (params.getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    private class UtilityClassWithoutPrivateConstructorVisitor
    extends BaseInspectionVisitor {
        private UtilityClassWithoutPrivateConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$UtilityClassWithoutPrivateConstructorVisitor.visitClass must not be null");
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (UtilityClassWithoutPrivateConstructorInspection.this.ignoreClassesWithOnlyMain && this.hasOnlyMain(aClass)) {
                return;
            }
            if (this.hasPrivateConstructor(aClass)) {
                return;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)aClass.getProject());
            Query query = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true, (boolean)true);
            PsiClass subclass = (PsiClass)query.findFirst();
            if (subclass != null) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasOnlyMain(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length == 0) {
                return false;
            }
            for (PsiMethod method : methods) {
                if (method.isConstructor()) continue;
                if (!method.hasModifierProperty("static")) {
                    return false;
                }
                if (method.hasModifierProperty("private")) continue;
                if (!method.hasModifierProperty("public")) {
                    return false;
                }
                String name = method.getName();
                if (!name.equals("main")) {
                    return false;
                }
                PsiType returnType = method.getReturnType();
                if (!PsiType.VOID.equals(returnType)) {
                    return false;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 1) {
                    return false;
                }
                PsiParameter[] parameters = parameterList.getParameters();
                PsiParameter parameter = parameters[0];
                PsiType type = parameter.getType();
                if (type.equalsToText("java.lang.String[]")) continue;
                return false;
            }
            return true;
        }

        boolean hasPrivateConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("private")) continue;
                return true;
            }
            return false;
        }
    }

    private static class MakeConstructorPrivateFix
    extends InspectionGadgetsFix {
        private MakeConstructorPrivateFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.make.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$MakeConstructorPrivateFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethod[] constructurs;
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)classNameIdentifier.getParent();
            if (aClass == null) {
                return;
            }
            for (PsiMethod constructor : constructurs = aClass.getConstructors()) {
                PsiParameterList parameterList = constructor.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                PsiModifierList modifiers = constructor.getModifierList();
                modifiers.setModifierProperty("public", false);
                modifiers.setModifierProperty("protected", false);
                modifiers.setModifierProperty("private", true);
            }
        }
    }

    private static class CreateEmptyPrivateConstructor
    extends InspectionGadgetsFix {
        private CreateEmptyPrivateConstructor() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.create.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspection$CreateEmptyPrivateConstructor.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            final PsiClass aClass = (PsiClass)classNameIdentifier.getParent();
            if (aClass == null) {
                return;
            }
            Query query = ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope());
            for (PsiReference reference : query) {
                PsiElement element;
                PsiElement parent;
                if (reference == null || !((parent = (element = reference.getElement()).getParent()) instanceof PsiNewExpression)) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showInfoMessage((Project)aClass.getProject(), (String)"Utility class has instantiations, private constructor will not be created", (String)"Can't generate constructor");
                    }
                });
                return;
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiMethod constructor = factory.createConstructor();
            PsiModifierList modifierList = constructor.getModifierList();
            modifierList.setModifierProperty("private", true);
            aClass.add((PsiElement)constructor);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            styleManager.reformat((PsiElement)constructor);
        }
    }
}

