/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnFileRevision
implements VcsFileRevision {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.SvnFileRevision");
    private byte[] myContent;
    private final Date myDate;
    private final String myCommitMessage;
    private final String myAuthor;
    private final VcsRevisionNumber myRevisionNumber;
    private final SvnVcs myVCS;
    private final String myURL;
    private final SVNRevision myPegRevision;
    private final SVNRevision myRevision;
    private final String myCopyFromPath;
    private final List<SvnFileRevision> myMergeSources;

    public SvnFileRevision(SvnVcs vcs, SVNRevision pegRevision, SVNRevision revision, String url, String author, Date date, String commitMessage, String copyFromPath) {
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myAuthor = author;
        this.myDate = date;
        this.myCommitMessage = commitMessage;
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
        this.myMergeSources = new ArrayList<SvnFileRevision>();
    }

    public SvnFileRevision(SvnVcs vcs, SVNRevision pegRevision, SVNLogEntry logEntry, String url, String copyFromPath) {
        SVNRevision revision = SVNRevision.create((long)logEntry.getRevision());
        this.myRevisionNumber = new SvnRevisionNumber(revision);
        this.myPegRevision = pegRevision;
        this.myRevision = revision;
        this.myAuthor = logEntry.getAuthor();
        this.myDate = logEntry.getDate();
        this.myCommitMessage = logEntry.getMessage();
        this.myCopyFromPath = copyFromPath;
        this.myVCS = vcs;
        this.myURL = url;
        this.myMergeSources = new ArrayList<SvnFileRevision>();
    }

    public String getURL() {
        return this.myURL;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public void addMergeSource(SvnFileRevision source) {
        this.myMergeSources.add(source);
    }

    public List<SvnFileRevision> getMergeSources() {
        return this.myMergeSources;
    }

    public void loadContent() throws VcsException {
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myURL, contents, this.myRevision, this.myPegRevision);
        if (ApplicationManager.getApplication().isDispatchThread() && !this.myRevision.isLocal()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, this.myVCS.getProject());
        } else {
            loader.run();
        }
        if (loader.getException() != null) {
            SVNException svnException = loader.getException();
            LOG.info("Failed to load file '" + this.myURL + "' content at revision: " + this.myRevision + "\n" + svnException.getMessage(), (Throwable)svnException);
            throw new VcsException((Throwable)svnException);
        }
        this.myContent = contents.toByteArray();
    }

    public byte[] getContent() throws IOException {
        return this.myContent;
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    private class ContentLoader
    implements Runnable {
        private final SVNRevision myRevision;
        private final SVNRevision myPegRevision;
        private final String myURL;
        private final OutputStream myDst;
        private SVNException myException;

        public ContentLoader(String url, OutputStream dst, SVNRevision revision, SVNRevision pegRevision) {
            this.myURL = url;
            this.myDst = dst;
            this.myRevision = revision;
            this.myPegRevision = pegRevision;
        }

        public SVNException getException() {
            return this.myException;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myURL));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                SVNWCClient client = SvnFileRevision.this.myVCS.createWCClient();
                client.doGetFileContents(SVNURL.parseURIEncoded((String)this.myURL), this.myPegRevision, this.myRevision, true, this.myDst);
            }
            catch (SVNException e) {
                this.myException = e;
            }
        }
    }
}

