/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.NotNullFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.SvnRepositoryTreeCellRenderer;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class RepositoryBrowserComponent
extends JPanel
implements Disposable,
DataProvider {
    private JTree myRepositoryTree;
    private final SvnVcs myVCS;

    public RepositoryBrowserComponent(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent.<init> must not be null");
        }
        this.myVCS = vcs;
        this.createComponent();
    }

    public JTree getRepositoryTree() {
        return this.myRepositoryTree;
    }

    public void setRepositoryURLs(SVNURL[] urls, boolean showFiles) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        model.setRoots(urls);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
    }

    public void setRepositoryURL(SVNURL url, boolean showFiles, NotNullFunction<RepositoryBrowserComponent, Expander> defaultExpanderFactory) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        model.setDefaultExpanderFactory(defaultExpanderFactory);
        model.setSingleRoot(url);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
        this.myRepositoryTree.setRootVisible(true);
        this.myRepositoryTree.setSelectionRow(0);
    }

    public void setRepositoryURL(SVNURL url, boolean showFiles) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        model.setSingleRoot(url);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
        this.myRepositoryTree.setRootVisible(true);
        this.myRepositoryTree.setSelectionRow(0);
    }

    public void expandNode(@NotNull TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent.expandNode must not be null");
        }
        Object[] pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode);
        if (pathToNode != null && pathToNode.length > 0) {
            TreePath treePath = new TreePath(pathToNode);
            this.myRepositoryTree.expandPath(treePath);
        }
    }

    public Collection<TreeNode> getExpandedSubTree(@NotNull TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent.getExpandedSubTree must not be null");
        }
        Object[] pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode);
        Enumeration<TreePath> expanded = this.myRepositoryTree.getExpandedDescendants(new TreePath(pathToNode));
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        while (expanded.hasMoreElements()) {
            TreePath treePath = expanded.nextElement();
            result.add((TreeNode)treePath.getLastPathComponent());
        }
        return result;
    }

    public boolean isExpanded(@NotNull TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent.isExpanded must not be null");
        }
        Object[] pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode);
        return pathToNode != null && pathToNode.length > 0 && this.myRepositoryTree.isExpanded(new TreePath(pathToNode));
    }

    public void addURL(String url) {
        try {
            ((RepositoryTreeModel)this.myRepositoryTree.getModel()).addRoot(SVNURL.parseURIEncoded((String)url));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public void removeURL(String url) {
        try {
            ((RepositoryTreeModel)this.myRepositoryTree.getModel()).removeRoot(SVNURL.parseURIEncoded((String)url));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    @Nullable
    public SVNDirEntry getSelectedEntry() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object element = selection.getLastPathComponent();
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)element;
            return node.getSVNDirEntry();
        }
        return null;
    }

    @Nullable
    public String getSelectedURL() {
        SVNURL selectedUrl = this.getSelectedSVNURL();
        return selectedUrl == null ? null : selectedUrl.toString();
    }

    @Nullable
    public SVNURL getSelectedSVNURL() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object element = selection.getLastPathComponent();
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)element;
            return node.getURL();
        }
        return null;
    }

    public void addChangeListener(TreeSelectionListener l) {
        this.myRepositoryTree.addTreeSelectionListener(l);
    }

    public void removeChangeListener(TreeSelectionListener l) {
        this.myRepositoryTree.removeTreeSelectionListener(l);
    }

    public Component getPreferredFocusedComponent() {
        return this.myRepositoryTree;
    }

    private void createComponent() {
        this.setLayout(new BorderLayout());
        this.myRepositoryTree = new JTree();
        this.myRepositoryTree.getSelectionModel().setSelectionMode(1);
        this.myRepositoryTree.setRootVisible(false);
        this.myRepositoryTree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(this.myRepositoryTree, 22, 32);
        this.add((Component)scrollPane, "Center");
        this.myRepositoryTree.setCellRenderer((TreeCellRenderer)((Object)new SvnRepositoryTreeCellRenderer()));
        EditSourceOnDoubleClickHandler.install((JTree)this.myRepositoryTree);
    }

    @Nullable
    public RepositoryTreeNode getSelectedNode() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection != null && selection.getLastPathComponent() instanceof RepositoryTreeNode) {
            return (RepositoryTreeNode)selection.getLastPathComponent();
        }
        return null;
    }

    public void setSelectedNode(@NotNull TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent.setSelectedNode must not be null");
        }
        Object[] pathNodes = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(node);
        this.myRepositoryTree.setSelectionPath(new TreePath(pathNodes));
    }

    @Nullable
    public VirtualFile getSelectedVcsFile() {
        RepositoryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        SVNDirEntry entry = node.getSVNDirEntry();
        if (entry == null || entry.getKind() != SVNNodeKind.FILE) {
            return null;
        }
        String name = entry.getName();
        FileTypeManager manager = FileTypeManager.getInstance();
        if (entry.getName().lastIndexOf(46) > 0 && !manager.getFileTypeByFileName(name).isBinary()) {
            SVNURL url = node.getURL();
            SVNRevision rev = SVNRevision.create((long)entry.getRevision());
            SvnFileRevision revision = new SvnFileRevision(this.myVCS, SVNRevision.UNDEFINED, rev, url.toString(), entry.getAuthor(), entry.getDate(), null, null);
            return new VcsVirtualFile(node.getSVNDirEntry().getName(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            Project project = this.myVCS.getProject();
            if (project == null || project.isDefault()) {
                return null;
            }
            VirtualFile vcsFile = this.getSelectedVcsFile();
            return vcsFile != null ? new OpenFileDescriptor(project, vcsFile) : null;
        }
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myVCS.getProject();
        }
        return null;
    }

    public void dispose() {
    }

    public void setLazyLoadingExpander(NotNullFunction<RepositoryBrowserComponent, Expander> expanderFactory) {
        ((RepositoryTreeModel)this.myRepositoryTree.getModel()).setDefaultExpanderFactory(expanderFactory);
    }
}

