/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;

@State(name="SvnBranchMapperManager", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class SvnBranchMapperManager
implements PersistentStateComponent<SvnBranchMapperHolder> {
    private SvnBranchMapperHolder myStateHolder = new SvnBranchMapperHolder();
    public static final Topic<WcRootsChangeConsumer> WC_ROOTS_CHANGED = new Topic("SVN_WC_ROOTS_CHANGED", WcRootsChangeConsumer.class);

    public static SvnBranchMapperManager getInstance() {
        return (SvnBranchMapperManager)ServiceManager.getService(SvnBranchMapperManager.class);
    }

    public SvnBranchMapperHolder getState() {
        return this.myStateHolder;
    }

    public void loadState(SvnBranchMapperHolder state) {
        this.myStateHolder = state;
    }

    public void put(String url, String value) {
        this.myStateHolder.put(url, value);
        SvnBranchMapperManager.notifyWcRootsChanged(url, Collections.unmodifiableCollection(this.myStateHolder.get(url)));
    }

    public void remove(String url, File value) {
        Set<String> set = this.myStateHolder.get(url);
        if (set != null) {
            set.remove(value.getAbsolutePath());
        }
        SvnBranchMapperManager.notifyWcRootsChanged(url, Collections.unmodifiableCollection(set));
    }

    private static void notifyWcRootsChanged(String url, Collection<String> roots) {
        ((WcRootsChangeConsumer)ApplicationManager.getApplication().getMessageBus().syncPublisher(WC_ROOTS_CHANGED)).rootsChanged(url, roots);
    }

    public void notifyBranchesChanged(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration) {
        Map<String, String> map = configuration.getUrl2FileMappings(project, vcsRoot);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Set<String> get(String key) {
        return this.myStateHolder.get(key);
    }

    public static interface WcRootsChangeConsumer {
        public void rootsChanged(String var1, Collection<String> var2);
    }

    public static class SvnBranchMapperHolder {
        public Map<String, Set<String>> myMapping = new HashMap<String, Set<String>>();

        public void put(String key, String value) {
            Set<String> files = this.myMapping.get(key);
            if (files == null) {
                files = new HashSet<String>();
                this.myMapping.put(key, files);
            }
            files.add(value);
        }

        public Set<String> get(String key) {
            return this.myMapping.get(key);
        }
    }
}

