/*
 * Decompiled with CFR 0.152.
 */
package org.testng.v6;

import java.util.List;
import org.testng.ITestNGMethod;
import org.testng.v6.IRunGroupFactory;
import org.testng.v6.Lists;
import org.testng.v6.RunGroup;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation {
    private ITestNGMethod m_method;
    private Object m_object;
    private Object m_parameters;
    private int m_affinity;
    private List<RunGroup> m_runGroups = Lists.newArrayList();
    private IRunGroupFactory m_runGroupFactory;
    private Integer[] m_after = new Integer[0];
    private XmlTest m_xmlTest;

    public Operation(ITestNGMethod method, IRunGroupFactory runGroupFactory, XmlTest xmlTest) {
        this.init(method, 0, runGroupFactory, xmlTest);
    }

    public Operation(ITestNGMethod method, int threadAffinity, IRunGroupFactory runGroupFactory, XmlTest xmlTest) {
        this.init(method, threadAffinity, runGroupFactory, xmlTest);
    }

    private void init(ITestNGMethod method, int affinity, IRunGroupFactory runGroupFactory, XmlTest xmlTest) {
        this.m_method = method;
        this.m_affinity = affinity;
        this.m_runGroupFactory = runGroupFactory;
        this.m_xmlTest = xmlTest;
        this.m_runGroups.add(this.m_runGroupFactory.getRunGroup(2, method.getTestClass().getRealClass().getName()));
        this.m_runGroups.add(this.m_runGroupFactory.getRunGroup(1, this.m_xmlTest.getName()));
        for (String group : method.getGroups()) {
            this.m_runGroups.add(this.m_runGroupFactory.getRunGroup(3, group));
        }
    }

    public List<RunGroup> getRunGroups() {
        return this.m_runGroups;
    }

    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public String toString() {
        String padding = this.m_method.isBeforeClassConfiguration() || this.m_method.isAfterClassConfiguration() ? "    " : (this.m_method.isBeforeGroupsConfiguration() || this.m_method.isAfterGroupsConfiguration() ? "        " : (this.m_method.isBeforeMethodConfiguration() || this.m_method.isAfterMethodConfiguration() ? "            " : (this.m_method.isBeforeSuiteConfiguration() || this.m_method.isAfterSuiteConfiguration() ? "" : "                -- ")));
        String after = "";
        if (this.m_after.length > 0) {
            after = "after:";
            Integer[] arr$ = this.m_after;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                after = new StringBuffer().append(after).append(i).append(" ").toString();
            }
        }
        String method = new StringBuffer().append(this.m_method.getTestClass().getName()).append(".").append(this.m_method.getMethod().getName()).toString();
        String result = new StringBuffer().append(padding).append("[").append(method).append(" affinity:").append(this.m_affinity).append(" groups:").append(this.m_runGroups).append(after).append("]").toString();
        return result;
    }

    public int getAffinity() {
        return this.m_affinity;
    }

    public boolean mustRunAfter(Operation o) {
        List<RunGroup> runGroups = o.getRunGroups();
        Integer[] arr$ = this.m_after;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int after = arr$[i$];
            for (RunGroup rg : runGroups) {
                if (rg.getId() != after) continue;
                return true;
            }
        }
        return false;
    }

    public Integer[] getAfter() {
        return this.m_after;
    }

    public void setAfter(Integer[] after) {
        this.m_after = after;
    }
}

