/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.IAnnotationTransformer;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.internal.Parameters;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JDK5_ANNOTATIONFINDER_CLASS = "org.testng.internal.annotations.JDK15AnnotationFinder";
    static /* synthetic */ Class class$org$testng$annotations$IFactoryAnnotation;
    static /* synthetic */ Class class$org$testng$IAnnotationTransformer;
    static /* synthetic */ Class class$org$testng$annotations$IParametersAnnotation;
    static /* synthetic */ Class class$java$lang$String;

    private ClassHelper() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException(new StringBuffer().append("Class ").append(clazz.getName()).append(" does not have a no-args constructor").toString(), iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException(new StringBuffer().append("Cannot instantiate class ").append(clazz.getName()).toString(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException(new StringBuffer().append("An exception occurred in static initialization of class ").append(clazz.getName()).toString(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static Class<?> forName(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Exception ex) {
                ClassHelper.logInstantiationError(className, ex);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ClassHelper.logInstantiationError(className, cnfe);
            return null;
        }
    }

    private static void logInstantiationError(String className, Exception ex) {
        Utils.log("ClassHelper", 2, new StringBuffer().append("Could not instantiate ").append(className).append(": ").append(ex.getMessage()).toString());
    }

    public static Method findFactoryMethod(Class<?> cls, IAnnotationFinder finder) {
        Method result = null;
        for (Method method : cls.getMethods()) {
            IAnnotation f = finder.findAnnotation(method, class$org$testng$annotations$IFactoryAnnotation == null ? ClassHelper.class$("org.testng.annotations.IFactoryAnnotation") : class$org$testng$annotations$IFactoryAnnotation);
            if (null == f) continue;
            if (null != result) {
                throw new TestNGException(new StringBuffer().append(cls.getName()).append(":  only one @Factory method allowed").toString());
            }
            result = method;
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        for (Class<?> parent = clazz.getSuperclass(); null != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        try {
            IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_TESTRUNNER).newInstance();
            tr.setTestResultNotifier(runner);
            return tr;
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create JUnit runner org.testng.junit.JUnitTestRunner", ex);
        }
    }

    public static IAnnotationFinder createJdkAnnotationFinder(IAnnotationTransformer annoTransformer) {
        try {
            Class<?> clazz = ClassHelper.forName(JDK5_ANNOTATIONFINDER_CLASS);
            Constructor<?> ctor = clazz.getConstructor(class$org$testng$IAnnotationTransformer == null ? (class$org$testng$IAnnotationTransformer = ClassHelper.class$("org.testng.IAnnotationTransformer")) : class$org$testng$IAnnotationTransformer);
            return (IAnnotationFinder)ctor.newInstance(annoTransformer);
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create/initialize the JDK5 annotation finder org.testng.internal.annotations.JDK15AnnotationFinder", ex);
        }
    }

    private static Set<Method> extractMethods(Class<?> childClass, Class<?> clazz, Set<Method> collected) {
        HashSet<Method> methods = new HashSet<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers)) {
                if (ClassHelper.isOverridden(method, collected)) continue;
                methods.add(method);
                continue;
            }
            if (!isSamePackage || Modifier.isPrivate(methodModifiers) || ClassHelper.isOverridden(method, collected)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException(new StringBuffer().append("Couldn't find method selector : ").append(selector.getClassName()).toString(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory objectFactory) {
        Object result;
        try {
            Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
            if (null != constructor) {
                IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(constructor, class$org$testng$annotations$IParametersAnnotation == null ? (class$org$testng$annotations$IParametersAnnotation = ClassHelper.class$("org.testng.annotations.IParametersAnnotation")) : class$org$testng$annotations$IParametersAnnotation);
                String[] parameterNames = annotation.getValue();
                Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getParameters(), xmlTest.getSuite());
                result = objectFactory.newInstance(constructor, parameters);
            } else {
                boolean isStatic;
                Class[] parameterTypes = new Class[]{};
                Object[] parameters = new Object[]{};
                Class<?> ec = ClassHelper.getEnclosingClass(declaringClass);
                boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
                if (null != ec && !isStatic) {
                    Object[] enclosingInstances;
                    parameterTypes = new Class[]{ec};
                    IClass enclosingIClass = classes.get(ec);
                    if (null != enclosingIClass) {
                        enclosingInstances = enclosingIClass.getInstances(false);
                        if (null == enclosingInstances || enclosingInstances.length == 0) {
                            Object o = objectFactory.newInstance(ec.getConstructor(parameterTypes), new Object[0]);
                            enclosingIClass.addInstance(o);
                            enclosingInstances = new Object[]{o};
                        }
                    } else {
                        enclosingInstances = new Object[]{ec.newInstance()};
                    }
                    Object enclosingClassInstance = enclosingInstances[0];
                    parameters = new Object[]{enclosingClassInstance};
                }
                Constructor<?> ct = declaringClass.getDeclaredConstructor(parameterTypes);
                result = objectFactory.newInstance(ct, parameters);
            }
        }
        catch (TestNGException ex) {
            throw ex;
        }
        catch (NoSuchMethodException ex) {
            result = ClassHelper.tryOtherConstructor(declaringClass);
        }
        catch (Throwable cause) {
            throw new TestNGException(new StringBuffer().append("An error occured while instantiating class ").append(declaringClass.getName()).append(": ").append(cause.getMessage()).toString(), cause);
        }
        return result;
    }

    private static Class<?> getEnclosingClass(Class<?> declaringClass) {
        Class<?> result = null;
        String className = declaringClass.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            String ecn = className.substring(0, index);
            try {
                result = Class.forName(ecn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder finder, Class<?> declaringClass) {
        Constructor<?>[] constructors = declaringClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> result = constructors[i];
            IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(result, class$org$testng$annotations$IParametersAnnotation == null ? ClassHelper.class$("org.testng.annotations.IParametersAnnotation") : class$org$testng$annotations$IParametersAnnotation);
            if (null == annotation) continue;
            String[] parameters = annotation.getValue();
            if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                throw new TestNGException(new StringBuffer().append("Parameter count mismatch:  ").append(result).append("\naccepts ").append(parameterTypes.length).append(" parameters but the @Test annotation declares ").append(parameters.length).toString());
            }
            return result;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            if (declaringClass.getModifiers() == 0) {
                return null;
            }
            Constructor<T> ctor = declaringClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ClassHelper.class$("java.lang.String")) : class$java$lang$String);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = new StringBuffer().append("Could not create an instance of class ").append(declaringClass).append(message != null ? new StringBuffer().append(": ").append(message).toString() : "").append(".\nPlease make sure it has a constructor that accepts either a String or no parameter.").toString();
            throw new TestNGException(error);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

