/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.settings.SpellCheckerSettingsPane;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerSettingsManager
implements SearchableConfigurable {
    private SpellCheckerSettingsPane settingsPane;
    private SpellCheckerSettings settings;
    private Project project;

    public static SpellCheckerSettingsManager getInstance(Project project) {
        return (SpellCheckerSettingsManager)ShowSettingsUtil.getInstance().findProjectConfigurable(project, SpellCheckerSettingsManager.class);
    }

    public SpellCheckerSettingsManager(Project project) {
        this.project = project;
        this.settings = SpellCheckerSettings.getInstance(project);
    }

    @Nls
    public String getDisplayName() {
        return SpellCheckerBundle.message("spelling", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.ide.settings.spelling";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        if (this.settingsPane == null) {
            this.settingsPane = new SpellCheckerSettingsPane(this.settings, this.project);
        }
        return this.settingsPane.getPane();
    }

    public boolean isModified() {
        return this.settingsPane == null || this.settingsPane.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.settingsPane != null) {
            this.settingsPane.apply();
        }
    }

    public void reset() {
        if (this.settingsPane != null) {
            this.settingsPane.reset();
        }
    }

    public void disposeUIResources() {
        this.settingsPane = null;
    }
}

