/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.SequenceIterator;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    public static List<Object> mergeSortedLists(List<Object> list1, List<Object> list2, Comparator<Object> comparator, boolean mergeEqualItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            Object element2;
            if (index1 >= list1.size()) {
                result.add(list2.get(index2++));
                continue;
            }
            if (index2 >= list2.size()) {
                result.add(list1.get(index1++));
                continue;
            }
            Object element1 = list1.get(index1);
            int c = comparator.compare(element1, element2 = list2.get(index2));
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        return result;
    }

    public static <T> void addAll(Collection<T> collection, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> ArrayList<T> collect(Iterator<T> iterator) {
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        return list;
    }

    public static <T> HashSet<T> collectSet(Iterator<T> iterator) {
        HashSet hashSet = new HashSet();
        ContainerUtil.addAll(hashSet, iterator);
        return hashSet;
    }

    public static <K, V> HashMap<K, V> assignKeys(Iterator<V> iterator, Convertor<V, K> keyConvertor) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            hashMap.put(keyConvertor.convert(value), value);
        }
        return hashMap;
    }

    public static <K, V> HashMap<K, Set<V>> classify(Iterator<V> iterator, Convertor<V, K> keyConvertor) {
        HashMap<K, LinkedHashSet<V>> hashMap = new HashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        return hashMap;
    }

    public static <K, V> HashMap<K, V> assignValues(Iterator<K> iterator, Convertor<K, V> valueConvertor) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        while (iterator.hasNext()) {
            K key = iterator.next();
            hashMap.put(key, valueConvertor.convert(key));
        }
        return hashMap;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.getInstance();
    }

    public static <T> Iterable<T> emptyIterable() {
        return EmptyIterable.getInstance();
    }

    @Nullable
    public static <T> T find(T[] array, Condition<T> condition) {
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(Iterable<? extends T> iterable, Processor<T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T[] iterable, Processor<? super T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V extends T> V find(Iterable<V> iterable, Condition<T> condition) {
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T> T find(Iterable<? extends T> iterable, final T equalTo) {
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(Iterator<V> iterator, Condition<T> condition) {
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    public static <T, V> List<V> map2List(T[] array, Function<T, V> mapper) {
        return ContainerUtil.map2List(Arrays.asList(array), mapper);
    }

    public static <T, V> List<V> map2List(Collection<? extends T> collection, Function<T, V> mapper) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    public static <T, V> Set<V> map2Set(T[] collection, Function<T, V> mapper) {
        return ContainerUtil.map2Set(Arrays.asList(collection), mapper);
    }

    public static <T, V> Set<V> map2Set(Collection<? extends T> collection, Function<T, V> mapper) {
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    public static <T> Object[] map2Array(T[] array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T> Object[] map2Array(Collection<T> array, Function<T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    public static <T, V> V[] map2Array(T[] array, Class<? extends V> aClass, Function<T, V> mapper) {
        return ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, Class<? extends V> aClass, Function<T, V> mapper) {
        List<V> list = ContainerUtil.map2List(collection, mapper);
        return list.toArray((Object[])Array.newInstance(aClass, list.size()));
    }

    public static <T, V> V[] map2Array(Collection<? extends T> collection, V[] to, Function<T, V> mapper) {
        return ContainerUtil.map2List(collection, mapper).toArray(to);
    }

    public static <T> List<T> findAll(T[] collection, Condition<? super T> condition) {
        return ContainerUtil.findAll(Arrays.asList(collection), condition);
    }

    public static <T> List<T> findAll(Collection<? extends T> collection, Condition<? super T> condition) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> skipNulls(Collection<? extends T> collection) {
        return ContainerUtil.findAll(collection, Condition.NOT_NULL);
    }

    public static <T, V> List<V> findAll(T[] collection, Class<V> instanceOf) {
        return ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
    }

    public static <T, V> V[] findAllAsArray(T[] collection, Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        return list.toArray((Object[])Array.newInstance(instanceOf, list.size()));
    }

    public static <T, V> V[] findAllAsArray(Collection<? extends T> collection, Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        return list.toArray((Object[])Array.newInstance(instanceOf, list.size()));
    }

    public static <T> T[] findAllAsArray(T[] collection, Condition<? super T> instanceOf) {
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        return list.toArray((Object[])Array.newInstance(collection.getClass().getComponentType(), list.size()));
    }

    public static <T, V> List<V> findAll(Collection<? extends T> collection, Class<V> instanceOf) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> void removeDuplicates(Collection<T> collection) {
        HashSet<T> collected = new HashSet<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    public static <T> Iterator<T> iterate(T[] arrays) {
        return Arrays.asList(arrays).iterator();
    }

    public static <T> Iterator<T> iterate(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> iterate(T[] arrays, Condition<? super T> condition) {
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    public static <T> Iterable<T> iterate(final Collection<? extends T> collection, final Condition<? super T> condition) {
        if (collection.isEmpty()) {
            return ContainerUtil.emptyIterable();
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> impl;
                    T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <E> void swapElements(List<E> list, int index1, int index2) {
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    public static <T> ArrayList<T> collect(Iterator<?> iterator, FilteringIterator.InstanceOf<T> instanceOf) {
        return ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
    }

    public static <T> void addAll(Collection<T> collection, Enumeration<T> enumeration) {
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    public static <T, U extends T> U findInstance(Iterable<T> iterable, Class<U> aClass) {
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(Iterator<T> iterator, Class<U> aClass) {
        return (U)ContainerUtil.find(iterator, new FilteringIterator.InstanceOf<U>(aClass));
    }

    @Nullable
    public static <T, U extends T> U findInstance(T[] array, Class<U> aClass) {
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    public static <T, V> List<T> concat(V[] array, Function<V, Collection<? extends T>> fun) {
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    public static <T> List<T> concat(Iterable<? extends Collection<T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> ts : list) {
            result.addAll(ts);
        }
        return result;
    }

    public static <T> List<T> concat(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        return ContainerUtil.concat(new List[]{list1, list2});
    }

    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Iterable iterable : iterables) {
                    iterators[i] = iterable.iterator();
                }
                return new SequenceIterator(iterators);
            }
        };
    }

    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    public static <T, V> List<T> concat(Iterable<? extends V> list, Function<V, Collection<? extends T>> fun) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(fun.fun(v));
        }
        return result;
    }

    public static <T> boolean intersects(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getFirstItem(Collection<T> items, T def) {
        return items == null || items.isEmpty() ? def : items.iterator().next();
    }

    public static <T> Collection<T> subtract(Collection<T> from, Collection<T> what) {
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        return set;
    }

    public static <T> T[] toArray(List<T> collection, T[] array) {
        int length = array.length;
        if (length < 20) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            return array;
        }
        return collection.toArray(array);
    }

    public static <T> T[] toArray(Collection<T> c, T[] sample) {
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            return sample;
        }
        return c.toArray(sample);
    }

    public static <T extends Comparable<T>> void sort(List<T> list) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(List<T> list, Comparator<T> comparator) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(T[] a) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    public static <T> void sort(T[] a, Comparator<T> comparator) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    public static <T, V> List<V> map(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        return result;
    }

    public static <T, V> List<V> mapNotNull(T[] array, Function<T, V> mapping) {
        return ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
    }

    public static <T, V> List<V> mapNotNull(Iterable<? extends T> iterable, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> packNullables(T ... elements) {
        ArrayList list = new ArrayList();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(element, list);
        }
        return list;
    }

    public static <T, V> List<V> map(T[] arr, Function<T, V> mapping) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        return result;
    }

    public static <T, V> V[] map(T[] arr, Function<T, V> mapping, V[] emptyArray) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        return result.toArray(emptyArray);
    }

    public static <T> void addIfNotNull(T element, Collection<T> result) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <K, V> void putIfNotNull(K key, V value, Map<K, V> result) {
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <T> void add(final T element, final Collection<T> result, Disposable parentDisposable) {
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        return element == null ? Collections.emptyList() : Arrays.asList(element);
    }

    public static <T, V> V getOrCreate(Map<T, V> result, T key, V defaultValue) {
        V value = result.get(key);
        if (value == null) {
            value = defaultValue;
            result.put(key, value);
        }
        return value;
    }

    public static <T, V> V getOrCreate(Map<T, V> result, T key, Factory<V> factory) {
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    public static <T> boolean and(T[] iterable, Condition<T> condition) {
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    public static <T> boolean and(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean or(T[] iterable, Condition<T> condition) {
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    public static <T> boolean or(Iterable<T> iterable, Condition<T> condition) {
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<T, T> next) {
        if (next == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.unfold must not be null");
        }
        if (t == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        return list;
    }

    public static <T> List<T> dropTail(List<T> items) {
        return items.subList(0, items.size() - 1);
    }

    public static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> void quickSort(List<T> list, Comparator<? super T> comparator) {
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(List<T> x, Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtil.<T>emptyList());
    }

    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @NotNull
    public static <T> Set<T> singleton(final T o, final @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.singleton must not be null");
        }
        Set set = new Set<T>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object elem) {
                return strategy.equals(o, elem);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    boolean atEnd;

                    @Override
                    public boolean hasNext() {
                        return !this.atEnd;
                    }

                    @Override
                    public T next() {
                        if (this.atEnd) {
                            throw new NoSuchElementException();
                        }
                        this.atEnd = true;
                        return o;
                    }

                    @Override
                    public void remove() {
                        throw new IncorrectOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return new Object[]{o};
            }

            @Override
            public <T> T[] toArray(T[] a) {
                assert (a.length == 1);
                a[0] = o;
                return a;
            }

            @Override
            public boolean add(T t) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return false;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new IncorrectOperationException();
            }

            @Override
            public void clear() {
                throw new IncorrectOperationException();
            }
        };
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.singleton must not return null");
        }
        return set;
    }

    private static class EmptyList
    extends AbstractList<Object>
    implements RandomAccess,
    Serializable {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public Object[] toArray() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }
    }
}

