/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceProvider
extends PsiReferenceProvider {
    private final boolean myDefaultSoft;

    public PropertiesReferenceProvider() {
        this(false);
    }

    public PropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        boolean soft;
        boolean propertyRefWithPrefix;
        String bundleName;
        Object value;
        block14: {
            block13: {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceProvider.getReferencesByElement must not be null");
                }
                if (context == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/PropertiesReferenceProvider.getReferencesByElement must not be null");
                }
                value = null;
                bundleName = null;
                propertyRefWithPrefix = false;
                soft = this.myDefaultSoft;
                if (!(element instanceof PsiLiteralExpression)) break block13;
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
                value = literalExpression.getValue();
                HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                annotationParams.put("resourceBundle", null);
                if (JavaI18nUtil.mustBePropertyKey(literalExpression, annotationParams)) {
                    soft = false;
                    Object resourceBundleName = annotationParams.get("resourceBundle");
                    if (resourceBundleName instanceof PsiExpression) {
                        PsiExpression expr = (PsiExpression)resourceBundleName;
                        Object bundleValue = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
                        bundleName = bundleValue == null ? null : bundleValue.toString();
                    }
                }
                break block14;
            }
            if (element instanceof XmlAttributeValue && PropertiesReferenceProvider.isNonDynamicAttribute(element)) {
                XmlTag parent;
                if (element.getTextLength() < 2) {
                    psiReferenceArray = PsiReference.EMPTY_ARRAY;
                    if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesReferenceProvider.getReferencesByElement must not return null");
                    return psiReferenceArray;
                }
                value = ((XmlAttributeValue)element).getValue();
                XmlAttribute attribute = (XmlAttribute)element.getParent();
                if ("key".equals(attribute.getName()) && "message".equals((parent = attribute.getParent()).getLocalName()) && Arrays.binarySearch(XmlUtil.JSTL_FORMAT_URIS, parent.getNamespace()) >= 0) {
                    propertyRefWithPrefix = true;
                }
            }
        }
        if (value instanceof String) {
            String text = (String)value;
            PrefixBasedPropertyReference reference = propertyRefWithPrefix ? new PrefixBasedPropertyReference(text, element, bundleName, soft) : new PropertyReference(text, element, bundleName, soft);
            psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = PsiReference.EMPTY_ARRAY;
        if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesReferenceProvider.getReferencesByElement must not return null");
    }

    static boolean isNonDynamicAttribute(PsiElement element) {
        return PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{OuterLanguageElement.class, JspXmlTagBase.class}) == null;
    }
}

