/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GitUpdateOptionsPanel {
    private static final String MERGE = GitBundle.getString("update.options.type.merge");
    private static final String REBASE = GitBundle.getString("update.options.type.rebase");
    private static final String DEFAULT = GitBundle.getString("update.options.type.default");
    private JComboBox myTypeComboBox;
    private JCheckBox myStashChangesCheckBox;
    private JPanel myPanel;

    public GitUpdateOptionsPanel() {
        this.$$$setupUI$$$();
        this.myTypeComboBox.addItem(DEFAULT);
        this.myTypeComboBox.addItem(REBASE);
        this.myTypeComboBox.addItem(MERGE);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public boolean isModified(GitVcsSettings settings) {
        GitVcsSettings.UpdateType type = this.getUpdateType();
        return type != settings.getUpdateType() || this.myStashChangesCheckBox.isSelected() != settings.isStashOnUpdate();
    }

    private GitVcsSettings.UpdateType getUpdateType() {
        GitVcsSettings.UpdateType type = null;
        String typeVal = (String)this.myTypeComboBox.getSelectedItem();
        if (REBASE.equals(typeVal)) {
            type = GitVcsSettings.UpdateType.REBASE;
        } else if (MERGE.equals(typeVal)) {
            type = GitVcsSettings.UpdateType.MERGE;
        } else if (DEFAULT.equals(typeVal)) {
            type = GitVcsSettings.UpdateType.BRANCH_DEFAULT;
        }
        assert (type != null);
        return type;
    }

    public void applyTo(GitVcsSettings settings) {
        settings.setUpdateType(this.getUpdateType());
        settings.setUpdateStash(this.myStashChangesCheckBox.isSelected());
    }

    public void updateFrom(GitVcsSettings settings) {
        this.myStashChangesCheckBox.setSelected(settings.isStashOnUpdate());
        String value = null;
        switch (settings.getUpdateType()) {
            case REBASE: {
                value = REBASE;
                break;
            }
            case MERGE: {
                value = MERGE;
                break;
            }
            case BRANCH_DEFAULT: {
                value = DEFAULT;
                break;
            }
            default: {
                assert (false) : "Unknown value of update type: " + (Object)((Object)settings.getUpdateType());
                break;
            }
        }
        this.myTypeComboBox.setSelectedItem(value);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStashChangesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.stash.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.stash"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.tooltip"));
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

