/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.impl.AntAntImpl;
import com.intellij.lang.ant.psi.impl.AntBuildNumberImpl;
import com.intellij.lang.ant.psi.impl.AntCallImpl;
import com.intellij.lang.ant.psi.impl.AntDirSetImpl;
import com.intellij.lang.ant.psi.impl.AntFileListImpl;
import com.intellij.lang.ant.psi.impl.AntFileSetImpl;
import com.intellij.lang.ant.psi.impl.AntImportImpl;
import com.intellij.lang.ant.psi.impl.AntMacroDefImpl;
import com.intellij.lang.ant.psi.impl.AntPathImpl;
import com.intellij.lang.ant.psi.impl.AntPresetDefImpl;
import com.intellij.lang.ant.psi.impl.AntProjectImpl;
import com.intellij.lang.ant.psi.impl.AntPropertyImpl;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.impl.AntTargetImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.impl.AntTimestampFormatImpl;
import com.intellij.lang.ant.psi.impl.AntTypeDefImpl;
import com.intellij.lang.ant.psi.impl.reference.providers.AntAttributeReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntElementNameReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntFileReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntMacroDefParameterReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntPropertyReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntRefIdReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntSingleTargetReferenceProvider;
import com.intellij.lang.ant.psi.impl.reference.providers.AntTargetListReferenceProvider;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class AntReferenceProvidersRegistry {
    private static final Map<Class, PsiReferenceProvider[]> ourProviders = new HashMap();

    private AntReferenceProvidersRegistry() {
    }

    public static PsiReferenceProvider[] getProvidersByElement(AntElement element) {
        PsiReferenceProvider[] result = ourProviders.get(element.getClass());
        return result != null ? result : PsiReferenceProvider.EMPTY_ARRAY;
    }

    static {
        AntAttributeReferenceProvider attrProvider = new AntAttributeReferenceProvider();
        AntElementNameReferenceProvider nameProvider = new AntElementNameReferenceProvider();
        AntPropertyReferenceProvider propProvider = new AntPropertyReferenceProvider();
        AntFileReferenceProvider fileProvider = new AntFileReferenceProvider();
        AntRefIdReferenceProvider refIdProvider = new AntRefIdReferenceProvider();
        AntMacroDefParameterReferenceProvider macroParamsProvider = new AntMacroDefParameterReferenceProvider();
        AntSingleTargetReferenceProvider targetProvider = new AntSingleTargetReferenceProvider();
        ourProviders.put(AntProjectImpl.class, new PsiReferenceProvider[]{targetProvider, nameProvider, attrProvider});
        ourProviders.put(AntTargetImpl.class, new PsiReferenceProvider[]{new AntTargetListReferenceProvider(), propProvider, refIdProvider, nameProvider, attrProvider});
        ourProviders.put(AntStructuredElementImpl.class, new PsiReferenceProvider[]{fileProvider, propProvider, refIdProvider, nameProvider, attrProvider, macroParamsProvider});
        ourProviders.put(AntTimestampFormatImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntTaskImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntPropertyImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntMacroDefImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntPresetDefImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntTypeDefImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntImportImpl.class, new PsiReferenceProvider[]{fileProvider, propProvider, nameProvider, attrProvider});
        ourProviders.put(AntAntImpl.class, new PsiReferenceProvider[]{fileProvider, propProvider, nameProvider, attrProvider, targetProvider, macroParamsProvider});
        ourProviders.put(AntBuildNumberImpl.class, new PsiReferenceProvider[]{fileProvider, propProvider, nameProvider, attrProvider, macroParamsProvider});
        ourProviders.put(AntCallImpl.class, new PsiReferenceProvider[]{targetProvider, propProvider, refIdProvider, nameProvider, attrProvider, macroParamsProvider});
        ourProviders.put(AntDirSetImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntFileListImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntFileSetImpl.class, ourProviders.get(AntStructuredElementImpl.class));
        ourProviders.put(AntPathImpl.class, ourProviders.get(AntStructuredElementImpl.class));
    }
}

