/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntFilesProviderImpl;
import com.intellij.lang.ant.psi.impl.AntPattern;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntFileListImpl
extends AntFilesProviderImpl {
    public AntFileListImpl(AntElement parent, XmlTag sourceElement) {
        super(parent, sourceElement);
    }

    public AntFileListImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        super(parent, sourceElement, definition, nameElementAttribute);
    }

    public AntFileListImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    @Override
    protected AntPattern getPattern() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<File> getFiles(AntPattern pattern, Set<AntFilesProvider> processed) {
        List<File> list;
        File root = this.getCanonicalFile(this.computeAttributeValue(this.getSourceElement().getAttributeValue("dir")));
        if (root == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileListImpl.getFiles must not return null");
            return list;
        }
        ArrayList<File> files = new ArrayList<File>();
        String filenames = this.getSourceElement().getAttributeValue("files");
        if (filenames != null) {
            StringTokenizer tokenizer = new StringTokenizer(filenames, ", \t\n\r\f", false);
            while (tokenizer.hasMoreTokens()) {
                files.add(new File(root, tokenizer.nextToken()));
            }
        }
        AntElement[] children = this.getChildren();
        AntTypeDefinition selfTypeDef = this.getTypeDefinition();
        if (selfTypeDef != null) {
            for (AntElement child : children) {
                String fileName;
                AntStructuredElement se;
                AntTypeDefinition typeDef;
                if (!(child instanceof AntStructuredElement) || (typeDef = (se = (AntStructuredElement)child).getTypeDefinition()) == null || selfTypeDef.getNestedClassName(typeDef.getTypeId()) == null || (fileName = this.computeAttributeValue(se.getSourceElement().getAttributeValue("name"))) == null) continue;
                files.add(new File(root, fileName));
            }
        }
        if ((list = files) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileListImpl.getFiles must not return null");
    }
}

