/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.JDOMUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenId;

public class MavenPlugin
implements Serializable {
    private String myGroupId;
    private String myArtifactId;
    private String myVersion;
    private boolean myDefault;
    private Element myConfiguration;
    private List<Execution> myExecutions = new ArrayList<Execution>();
    private List<MavenId> myDependencies = new ArrayList<MavenId>();

    protected MavenPlugin() {
    }

    public MavenPlugin(Plugin plugin, boolean isDefault) {
        this.myGroupId = plugin.getGroupId();
        this.myArtifactId = plugin.getArtifactId();
        this.myVersion = plugin.getVersion();
        this.myDefault = isDefault;
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        this.myConfiguration = config == null ? null : MavenPlugin.xppToElement(config);
        for (PluginExecution each : plugin.getExecutions()) {
            this.myExecutions.add(new Execution(each));
        }
        for (PluginExecution each : plugin.getDependencies()) {
            this.myDependencies.add(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()));
        }
    }

    private static Element xppToElement(Xpp3Dom xpp) {
        Element result = new Element(xpp.getName());
        Xpp3Dom[] children = xpp.getChildren();
        if (children == null || children.length == 0) {
            result.setText(xpp.getValue());
        } else {
            for (Xpp3Dom each : children) {
                result.addContent(MavenPlugin.xppToElement(each));
            }
        }
        return result;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public boolean isDefault() {
        return this.myDefault;
    }

    @Nullable
    public Element getConfigurationElement() {
        return this.myConfiguration;
    }

    public List<Execution> getExecutions() {
        return this.myExecutions;
    }

    public List<MavenId> getDependencies() {
        return this.myDependencies;
    }

    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenPlugin that = (MavenPlugin)o;
        if (this.myDefault != that.myDefault) {
            return false;
        }
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (!JDOMUtil.areElementsEqual((Element)this.myConfiguration, (Element)that.myConfiguration)) {
            return false;
        }
        if (this.myExecutions != null ? !((Object)this.myExecutions).equals(that.myExecutions) : that.myExecutions != null) {
            return false;
        }
        return !(this.myDependencies != null ? !((Object)this.myDependencies).equals(that.myDependencies) : that.myDependencies != null);
    }

    public int hashCode() {
        int result = this.myDefault ? 1 : 0;
        result = 31 * result + (this.myGroupId != null ? this.myGroupId.hashCode() : 0);
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myConfiguration != null ? JDOMUtil.getTreeHash((Element)this.myConfiguration) : 0);
        result = 31 * result + (this.myExecutions != null ? ((Object)this.myExecutions).hashCode() : 0);
        result = 31 * result + (this.myDependencies != null ? ((Object)this.myDependencies).hashCode() : 0);
        return result;
    }

    public static class Execution
    implements Serializable {
        private List<String> myGoals;
        private Element myConfiguration;

        public Execution() {
        }

        public Execution(PluginExecution execution) {
            this.myGoals = execution.getGoals();
            Xpp3Dom config = (Xpp3Dom)execution.getConfiguration();
            this.myConfiguration = config == null ? null : MavenPlugin.xppToElement(config);
        }

        public List<String> getGoals() {
            return this.myGoals;
        }

        @Nullable
        public Element getConfigurationElement() {
            return this.myConfiguration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution that = (Execution)o;
            if (this.myGoals != null ? !((Object)this.myGoals).equals(that.myGoals) : that.myGoals != null) {
                return false;
            }
            return JDOMUtil.areElementsEqual((Element)this.myConfiguration, (Element)that.myConfiguration);
        }

        public int hashCode() {
            int result = this.myGoals != null ? ((Object)this.myGoals).hashCode() : 0;
            result = 31 * result + (this.myConfiguration != null ? JDOMUtil.getTreeHash((Element)this.myConfiguration) : 0);
            return result;
        }
    }
}

