/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;

public class XDebuggerTreeRestorer
implements XDebuggerTreeListener,
TreeSelectionListener {
    private final XDebuggerTree myTree;
    private final Rectangle myLastVisibleNodeRect;
    private final Map<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo> myNode2State = new HashMap<XDebuggerTreeNode, XDebuggerTreeState.NodeInfo>();
    private final Map<XValueNodeImpl, XDebuggerTreeState.NodeInfo> myNode2ParentState = new HashMap<XValueNodeImpl, XDebuggerTreeState.NodeInfo>();
    private boolean myStopRestoringSelection;
    private boolean myInsideRestoring;

    public XDebuggerTreeRestorer(XDebuggerTree tree, Rectangle lastVisibleNodeRect) {
        this.myTree = tree;
        this.myLastVisibleNodeRect = lastVisibleNodeRect;
        tree.addTreeListener(this);
        tree.addTreeSelectionListener(this);
    }

    public void restoreChildren(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo nodeInfo) {
        if (nodeInfo.isExpanded()) {
            this.myTree.expandPath(treeNode.getPath());
            List<? extends XDebuggerTreeNode> children = treeNode.getLoadedChildren();
            if (children != null) {
                for (XDebuggerTreeNode xDebuggerTreeNode : children) {
                    this.restoreNode(xDebuggerTreeNode, nodeInfo);
                }
            }
            this.myNode2State.put(treeNode, nodeInfo);
        }
    }

    private void restoreNode(XDebuggerTreeNode treeNode, XDebuggerTreeState.NodeInfo parentInfo) {
        if (treeNode instanceof XValueNodeImpl) {
            XValueNodeImpl node = (XValueNodeImpl)treeNode;
            String nodeName = node.getName();
            String nodeValue = node.getValue();
            if (nodeName == null || nodeValue == null) {
                this.myNode2ParentState.put(node, parentInfo);
            } else {
                this.doRestoreNode(node, parentInfo, nodeName, nodeValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestoreNode(XValueNodeImpl treeNode, XDebuggerTreeState.NodeInfo parentInfo, String nodeName, String nodeValue) {
        XDebuggerTreeState.NodeInfo childInfo = parentInfo.removeChild(nodeName);
        if (childInfo != null) {
            if (!childInfo.getValue().equals(nodeValue)) {
                treeNode.markChanged();
            }
            if (!this.myStopRestoringSelection && childInfo.isSelected()) {
                try {
                    this.myInsideRestoring = true;
                    this.myTree.addSelectionPath(treeNode.getPath());
                }
                finally {
                    this.myInsideRestoring = false;
                }
            }
            this.restoreChildren(treeNode, childInfo);
        }
    }

    @Override
    public void nodeLoaded(@NotNull XValueNodeImpl node, String name, String value) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer.nodeLoaded must not be null");
        }
        XDebuggerTreeState.NodeInfo parentInfo = this.myNode2ParentState.remove(node);
        if (parentInfo != null) {
            this.doRestoreNode(node, parentInfo, name, value);
        }
        this.disposeIfFinished();
    }

    private void disposeIfFinished() {
        if (this.myNode2ParentState.isEmpty() && this.myNode2State.isEmpty()) {
            if (this.myLastVisibleNodeRect != null) {
                this.myTree.scrollRectToVisible(this.myLastVisibleNodeRect);
            }
            this.dispose();
        }
    }

    @Override
    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer.childrenLoaded must not be null");
        }
        if (children == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer.childrenLoaded must not be null");
        }
        XDebuggerTreeState.NodeInfo nodeInfo = this.myNode2State.get(node);
        if (nodeInfo != null) {
            for (XValueContainerNode<?> child : children) {
                this.restoreNode(child, nodeInfo);
            }
        }
        if (last) {
            this.myNode2State.remove(node);
            this.disposeIfFinished();
        }
    }

    public void dispose() {
        this.myNode2ParentState.clear();
        this.myNode2State.clear();
        this.myTree.removeTreeListener(this);
        this.myTree.removeTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.myInsideRestoring) {
            this.myStopRestoringSelection = true;
        }
    }
}

