/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerNodeLink;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTree
extends DnDAwareTree
implements DataProvider {
    private static final DataKey<XDebuggerTree> XDEBUGGER_TREE_KEY = DataKey.create((String)"xdebugger.tree");
    private static final Convertor<TreePath, String> SPEED_SEARCH_CONVERTER = new Convertor<TreePath, String>(){

        public String convert(TreePath o) {
            String text = null;
            if (o != null) {
                Object node = o.getLastPathComponent();
                if (node instanceof XValueNodeImpl) {
                    text = ((XValueNodeImpl)node).getName();
                } else if (node instanceof XDebuggerTreeNode) {
                    text = ((XDebuggerTreeNode)node).getText().toString();
                }
            }
            return text != null ? text : "";
        }
    };
    private final DefaultTreeModel myTreeModel;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private XSourcePosition mySourcePosition;
    private final List<XDebuggerTreeListener> myListeners;
    private final XDebugSession mySession;

    public XDebuggerTree(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.<init> must not be null");
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.<init> must not be null");
        }
        this.myListeners = ContainerUtil.createEmptyCOWList();
        this.mySession = session;
        this.myProject = session.getProject();
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myTreeModel = new DefaultTreeModel(null);
        this.setModel(this.myTreeModel);
        this.setCellRenderer((TreeCellRenderer)((Object)new XDebuggerTreeRenderer()));
        new TreeLinkMouseListener(new XDebuggerTreeRenderer()){

            @Override
            protected void handleTagClick(Object tag, MouseEvent event) {
                if (tag instanceof XDebuggerNodeLink) {
                    ((XDebuggerNodeLink)tag).onClick(event);
                }
            }
        }.install((JComponent)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreeNode parent;
                MessageTreeNode node;
                MessageTreeNode[] treeNodes;
                if (e.getClickCount() == 2 && (treeNodes = (MessageTreeNode[])XDebuggerTree.this.getSelectedNodes(MessageTreeNode.class, null)).length == 1 && (node = treeNodes[0]).isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
                    ((XValueContainerNode)parent).startComputingChildren();
                }
            }
        });
        new TreeSpeedSearch(this, SPEED_SEARCH_CONVERTER);
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.addTreeListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void removeTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.removeTreeListener must not be null");
        }
        this.myListeners.remove(listener);
    }

    public void setRoot(XDebuggerTreeNode root, boolean rootVisible) {
        this.setRootVisible(rootVisible);
        this.myTreeModel.setRoot(root);
    }

    public XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.myTreeModel.getRoot();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.getEditorsProvider must not return null");
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public XDebugSession getSession() {
        XDebugSession xDebugSession = this.mySession;
        if (xDebugSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.getSession must not return null");
        }
        return xDebugSession;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (XDEBUGGER_TREE_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void rebuildAndRestore(XDebuggerTreeState treeState) {
        Object rootNode = this.myTreeModel.getRoot();
        if (rootNode instanceof XDebuggerTreeNode) {
            ((XDebuggerTreeNode)rootNode).clearChildren();
            treeState.restoreState(this);
            this.repaint();
        }
    }

    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<XValueContainerNode<?>> children, boolean last) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.childrenLoaded must not be null");
        }
        if (children == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.childrenLoaded must not be null");
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.childrenLoaded(node, children, last);
        }
    }

    public void nodeLoaded(@NotNull XValueNodeImpl node, @NotNull String name, @NotNull String value) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.nodeLoaded must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.nodeLoaded must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTree.nodeLoaded must not be null");
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.nodeLoaded(node, name, value);
        }
    }

    public void markNodesObsolete() {
        Object root = this.myTreeModel.getRoot();
        if (root instanceof XValueContainerNode) {
            XDebuggerTree.markNodesObsolete((XValueContainerNode)root);
        }
    }

    private static void markNodesObsolete(XValueContainerNode<?> node) {
        node.setObsolete();
        List<XValueContainerNode<?>> loadedChildren = node.getLoadedChildren();
        if (loadedChildren != null) {
            for (XValueContainerNode<?> child : loadedChildren) {
                XDebuggerTree.markNodesObsolete(child);
            }
        }
    }

    @Nullable
    public static XDebuggerTree getTree(AnActionEvent e) {
        return (XDebuggerTree)((Object)e.getData(XDEBUGGER_TREE_KEY));
    }

    @Nullable
    public static XDebuggerTree getTree(DataContext context) {
        return (XDebuggerTree)((Object)XDEBUGGER_TREE_KEY.getData(context));
    }
}

