/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointBase<Self extends XBreakpoint<P>, P extends XBreakpointProperties, S extends BreakpointState>
extends UserDataHolderBase
implements XBreakpoint<P> {
    private final XBreakpointType<Self, P> myType;
    @Nullable
    private final P myProperties;
    protected final S myState;
    private final XBreakpointManagerImpl myBreakpointManager;

    public XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, S state) {
        this.myState = state;
        this.myType = type;
        this.myProperties = properties;
        this.myBreakpointManager = breakpointManager;
    }

    protected XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, S breakpointState) {
        this.myState = breakpointState;
        this.myType = type;
        this.myBreakpointManager = breakpointManager;
        this.myProperties = type.createProperties();
        if (this.myProperties != null) {
            Object state = XmlSerializer.deserialize((Element)((BreakpointState)this.myState).getPropertiesElement(), (Class)XDebuggerUtilImpl.getStateClass(this.myProperties.getClass()));
            this.myProperties.loadState(state);
        }
    }

    protected final Project getProject() {
        return this.myBreakpointManager.getProject();
    }

    protected XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    protected final void fireBreakpointChanged() {
        this.myBreakpointManager.fireBreakpointChanged(this);
    }

    public XSourcePosition getSourcePosition() {
        return null;
    }

    public Navigatable getNavigatable() {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            return null;
        }
        return position.createNavigatable(this.getProject());
    }

    public boolean isEnabled() {
        return ((BreakpointState)this.myState).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            ((BreakpointState)this.myState).setEnabled(enabled);
            this.fireBreakpointChanged();
        }
    }

    @NotNull
    public SuspendPolicy getSuspendPolicy() {
        SuspendPolicy suspendPolicy = ((BreakpointState)this.myState).mySuspendPolicy;
        if (suspendPolicy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointBase.getSuspendPolicy must not return null");
        }
        return suspendPolicy;
    }

    public void setSuspendPolicy(@NotNull SuspendPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointBase.setSuspendPolicy must not be null");
        }
        if (((BreakpointState)this.myState).mySuspendPolicy != policy) {
            ((BreakpointState)this.myState).mySuspendPolicy = policy;
            this.fireBreakpointChanged();
        }
    }

    public boolean isLogMessage() {
        return ((BreakpointState)this.myState).isLogMessage();
    }

    public void setLogMessage(boolean logMessage) {
        if (logMessage != this.isLogMessage()) {
            ((BreakpointState)this.myState).setLogMessage(logMessage);
            this.fireBreakpointChanged();
        }
    }

    public String getLogExpression() {
        return ((BreakpointState)this.myState).getLogExpression();
    }

    public void setLogExpression(@Nullable String expression) {
        if (!Comparing.equal((String)this.getLogExpression(), (String)expression)) {
            ((BreakpointState)this.myState).setLogExpression(expression);
            this.fireBreakpointChanged();
        }
    }

    public String getCondition() {
        return ((BreakpointState)this.myState).getCondition();
    }

    public void setCondition(@Nullable String condition) {
        if (!Comparing.equal((String)condition, (String)this.getCondition())) {
            ((BreakpointState)this.myState).setCondition(condition);
            this.fireBreakpointChanged();
        }
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public P getProperties() {
        return this.myProperties;
    }

    @NotNull
    public XBreakpointType<Self, P> getType() {
        XBreakpointType<Self, P> xBreakpointType = this.myType;
        if (xBreakpointType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XBreakpointBase.getType must not return null");
        }
        return xBreakpointType;
    }

    public S getState() {
        Element propertiesElement = this.myProperties != null ? XmlSerializer.serialize((Object)this.myProperties.getState()) : null;
        ((BreakpointState)this.myState).setPropertiesElement(propertiesElement);
        return this.myState;
    }

    public XBreakpointDependencyState getDependencyState() {
        return ((BreakpointState)this.myState).getDependencyState();
    }

    public void setDependencyState(XBreakpointDependencyState state) {
        ((BreakpointState)this.myState).setDependencyState(state);
    }

    public void dispose() {
    }

    @Tag(value="breakpoint")
    public static class BreakpointState<B extends XBreakpoint<P>, P extends XBreakpointProperties, T extends XBreakpointType<B, P>> {
        private String myTypeId;
        private boolean myEnabled;
        private Element myPropertiesElement;
        private SuspendPolicy mySuspendPolicy = SuspendPolicy.ALL;
        private boolean myLogMessage;
        private String myLogExpression;
        private String myCondition;
        private XBreakpointDependencyState myDependencyState;

        public BreakpointState() {
        }

        public BreakpointState(boolean enabled, String typeId) {
            this.myEnabled = enabled;
            this.myTypeId = typeId;
        }

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        @Attribute(value="type")
        public String getTypeId() {
            return this.myTypeId;
        }

        public void setTypeId(String typeId) {
            this.myTypeId = typeId;
        }

        @Tag(value="properties")
        public Element getPropertiesElement() {
            return this.myPropertiesElement;
        }

        public void setPropertiesElement(Element propertiesElement) {
            this.myPropertiesElement = propertiesElement;
        }

        @Attribute(value="suspend")
        public String getSuspendPolicy() {
            return this.mySuspendPolicy.name();
        }

        public void setSuspendPolicy(String suspendPolicy) {
            this.mySuspendPolicy = SuspendPolicy.valueOf((String)suspendPolicy);
        }

        @Attribute(value="log-message")
        public boolean isLogMessage() {
            return this.myLogMessage;
        }

        public void setLogMessage(boolean logMessage) {
            this.myLogMessage = logMessage;
        }

        @Tag(value="log-expression")
        public String getLogExpression() {
            return this.myLogExpression;
        }

        public void setLogExpression(String logExpression) {
            this.myLogExpression = logExpression;
        }

        @Tag(value="condition")
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(String condition) {
            this.myCondition = condition;
        }

        @Property(surroundWithTag=false)
        public XBreakpointDependencyState getDependencyState() {
            return this.myDependencyState;
        }

        public void setDependencyState(XBreakpointDependencyState dependencyState) {
            this.myDependencyState = dependencyState;
        }

        public XBreakpointBase<B, P, ?> createBreakpoint(@NotNull T type, @NotNull XBreakpointManagerImpl breakpointManager) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointState.createBreakpoint must not be null");
            }
            if (breakpointManager == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$BreakpointState.createBreakpoint must not be null");
            }
            return new XBreakpointBase(type, breakpointManager, this);
        }
    }
}

