/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InvocationStack<T> {
    public static final InvocationStack<Object> INSTANCE = new InvocationStack();
    private final ThreadLocal<List<Pair<JavaMethodSignature, T>>> myCallStacks = new ThreadLocal();

    public final void push(Method method, T o) {
        JavaMethodSignature signature = JavaMethodSignature.getSignature((Method)method);
        List<Pair<JavaMethodSignature, T>> stack = this.myCallStacks.get();
        if (stack == null) {
            stack = new ArrayList<Pair<JavaMethodSignature, T>>();
            this.myCallStacks.set(stack);
        }
        stack.add(Pair.create((Object)signature, o));
    }

    @Nullable
    public final T findDeepestInvocation(Method method, Condition<T> stopAt) {
        List<Pair<JavaMethodSignature, T>> stack = this.myCallStacks.get();
        JavaMethodSignature signature = JavaMethodSignature.getSignature((Method)method);
        for (int i = stack.size() - 2; i >= 0; --i) {
            Pair<JavaMethodSignature, T> pair = stack.get(i);
            if (stopAt.value(pair.second)) {
                return (T)stack.get((int)(i + 1)).second;
            }
            if (pair.first == signature) continue;
            return null;
        }
        return (T)(stack.isEmpty() ? null : stack.get((int)0).second);
    }

    public final Pair<JavaMethodSignature, T> pop() {
        List<Pair<JavaMethodSignature, T>> list = this.myCallStacks.get();
        return list.remove(list.size() - 1);
    }
}

