/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.debugger.UiDebuggerExtension;
import com.intellij.ui.debugger.extensions.UiScriptFileType;
import com.intellij.util.WaitFor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PlaybackDebugger
implements UiDebuggerExtension,
PlaybackRunner.StatusCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.PlaybackDebugger");
    private JPanel myComponent;
    private PlaybackRunner myRunner;
    private DefaultListModel myMessage = new DefaultListModel();
    private JTextField myScriptsPath = new JTextField();
    private static final String EXT = "ijs";
    private static final String DOT_EXT = ".ijs";
    private JTextField myCurrentScript = new JTextField();
    private VirtualFileAdapter myVfsListener;
    private boolean myChanged;
    private JList myList;
    private Document myDocument;
    private Editor myEditor;
    private PlaybackDebuggerState myState;

    private void initUi() {
        this.myComponent = new JPanel(new BorderLayout());
        javax.swing.event.DocumentListener docListener = new javax.swing.event.DocumentListener(){

            @Override
            public void insertUpdate(javax.swing.event.DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }

            @Override
            public void removeUpdate(javax.swing.event.DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }

            @Override
            public void changedUpdate(javax.swing.event.DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }
        };
        this.myState = (PlaybackDebuggerState)ServiceManager.getService(PlaybackDebuggerState.class);
        DefaultActionGroup controlGroup = new DefaultActionGroup();
        controlGroup.add((AnAction)new RunOnFameActivationAction());
        controlGroup.add((AnAction)new ActivateFrameAndRun());
        controlGroup.addSeparator();
        controlGroup.add((AnAction)new StopAction());
        controlGroup.addSeparator();
        controlGroup.add((AnAction)new SaveAction());
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)controlGroup, true).getComponent(), "West");
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.myCurrentScript, "Center");
        this.myCurrentScript.setText(this.myState.currentScript);
        this.myCurrentScript.setEditable(false);
        this.myCurrentScript.getDocument().addDocumentListener(docListener);
        DefaultActionGroup loadGroup = new DefaultActionGroup();
        loadGroup.add((AnAction)new SetScriptFileAction());
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)loadGroup, true);
        tb.setLayoutPolicy(0);
        right.add((Component)tb.getComponent(), "East");
        north.add((Component)right, "Center");
        this.myComponent.add((Component)north, "North");
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = EditorFactory.getInstance().createEditor(this.myDocument);
        this.myDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                PlaybackDebugger.this.myChanged = true;
            }
        });
        VirtualFile scriptFile = VirtualFileManager.getInstance().getFileSystem("file").findFileByPath(this.myState.currentScript);
        if (scriptFile != null) {
            this.loadFrom(scriptFile);
        }
        Splitter script2Log = new Splitter(true);
        script2Log.setFirstComponent((JComponent)new JScrollPane(this.myEditor.getComponent()));
        this.myList = new JList(this.myMessage);
        this.myList.setCellRenderer(new MyListRenderer());
        script2Log.setSecondComponent((JComponent)new JScrollPane(this.myList));
        this.myComponent.add((Component)script2Log, "Center");
        this.myVfsListener = new VirtualFileAdapter(){

            public void contentsChanged(VirtualFileEvent event) {
                VirtualFile file = PlaybackDebugger.this.getCurrentScriptFile();
                if (file != null && file.equals(event.getFile())) {
                    PlaybackDebugger.this.loadFrom(event.getFile());
                }
            }
        };
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.myVfsListener);
    }

    private VirtualFile getCurrentScriptFile() {
        String text = this.myCurrentScript.getText();
        return text != null ? LocalFileSystem.getInstance().findFileByIoFile(new File(text)) : null;
    }

    private boolean maybeCreateFile() {
        if (this.getCurrentScriptFile() != null) {
            return true;
        }
        try {
            String text = this.myCurrentScript.getText();
            if (text == null) {
                throw new Exception("Cannot create file with name:" + text);
            }
            File file = new File(text);
            File parentFile = file.getParentFile();
            try {
                VirtualFile parent = VfsUtil.createDirectories((String)parentFile.getAbsolutePath());
                parent.createChildData((Object)this, file.getName());
            }
            catch (IOException e) {
                throw new Exception(e.getMessage());
            }
            return true;
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Cannot Save File");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        BufferedWriter writer = null;
        try {
            if (!this.maybeCreateFile()) {
                return;
            }
            OutputStream os = this.getCurrentScriptFile().getOutputStream((Object)this);
            writer = new BufferedWriter(new OutputStreamWriter(os));
            String toWrite = this.myDocument.getText();
            writer.write(toWrite != null ? toWrite : "");
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Cannot save script");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private void loadFrom(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/debugger/extensions/PlaybackDebugger.loadFrom must not be null");
        }
        try {
            final String text = CharsetToolkit.bytesToString((byte[])file.contentsToByteArray());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    PlaybackDebugger.this.myDocument.setText((CharSequence)text);
                }
            });
            this.myCurrentScript.setText(file.getPresentableUrl());
            this.myChanged = false;
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Cannot load file");
        }
    }

    private File getScriptsFile() {
        String text = this.myScriptsPath.getText();
        if (text == null) {
            return null;
        }
        File file = new File(text);
        return file.exists() ? file : null;
    }

    private void activateAndRun() {
        assert (this.myRunner == null);
        this.myMessage.clear();
        IdeFrameImpl frame = this.getFrame();
        Component c = ((WindowManagerEx)WindowManager.getInstance()).getFocusedComponent(frame);
        if (c != null) {
            c.requestFocus();
        } else {
            frame.requestFocus();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlaybackDebugger.this.startWhenFrameActive();
            }
        });
    }

    private IdeFrameImpl getFrame() {
        Frame[] all;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrameImpl)each;
        }
        throw new IllegalStateException("Cannot find IdeFrame to run on");
    }

    private void runOnFrame() {
        assert (this.myRunner == null);
        this.startWhenFrameActive();
    }

    private void startWhenFrameActive() {
        this.myMessage.clear();
        this.addInfo("Waiting for IDE frame activation", -1);
        this.myRunner = new PlaybackRunner(this.myDocument.getText(), this, false);
        new Thread(){

            @Override
            public void run() {
                new WaitFor(){

                    protected boolean condition() {
                        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame || PlaybackDebugger.this.myRunner == null;
                    }
                };
                if (PlaybackDebugger.this.myRunner == null) {
                    PlaybackDebugger.this.message("Script stopped", -1);
                    return;
                }
                PlaybackDebugger.this.message("Starting script...", -1);
                try {
                    6.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (PlaybackDebugger.this.myRunner == null) {
                    PlaybackDebugger.this.message("Script stopped", -1);
                    return;
                }
                PlaybackDebugger.this.myRunner.run().doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        PlaybackDebugger.this.myRunner = null;
                    }
                });
            }
        }.start();
    }

    @Override
    public void error(final String text, final int currentLine) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                PlaybackDebugger.this.addError(text, currentLine);
            }
        });
    }

    @Override
    public void message(final String text, final int currentLine) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                PlaybackDebugger.this.addInfo(text, currentLine);
            }
        });
    }

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.initUi();
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Playback";
    }

    public void dispose() {
        this.disposeUiResources();
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
        LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVfsListener);
        this.myCurrentScript.setText("");
        this.myMessage.clear();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private void addInfo(String text, int line) {
        this.myMessage.addElement(new ListElement(text, false, line));
        this.scrollToLast();
    }

    private void addError(String text, int line) {
        this.myMessage.addElement(new ListElement(text, true, line));
        this.scrollToLast();
    }

    private void scrollToLast() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PlaybackDebugger.this.myMessage.size() == 0) {
                    return;
                }
                Rectangle rec = PlaybackDebugger.this.myList.getCellBounds(PlaybackDebugger.this.myMessage.getSize() - 1, PlaybackDebugger.this.myMessage.getSize() - 1);
                PlaybackDebugger.this.myList.scrollRectToVisible(rec);
            }
        });
    }

    private class MyListRenderer
    extends ColoredListCellRenderer {
        private MyListRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            ListElement listElement = (ListElement)value;
            String text = (listElement.getLine() >= 0 ? "Line " + listElement.getLine() + ":" : "") + listElement.getText();
            this.append(text, listElement.isError() ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private class ListElement {
        private String myText;
        private boolean myError;
        private int myLine;

        public ListElement(String text, boolean isError, int line) {
            this.myText = text;
            this.myError = isError;
            this.myLine = line;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isError() {
            return this.myError;
        }

        public int getLine() {
            return this.myLine;
        }
    }

    @State(name="PlaybackDebugger", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
    public static class PlaybackDebuggerState
    implements PersistentStateComponent<Element> {
        private static final String ATTR_CURRENT_SCRIPT = "currentScript";
        public String currentScript = "";

        public Element getState() {
            Element element = new Element("playback");
            element.setAttribute(ATTR_CURRENT_SCRIPT, this.currentScript);
            return element;
        }

        public void loadState(Element state) {
            String path = state.getAttributeValue(ATTR_CURRENT_SCRIPT);
            if (path != null) {
                this.currentScript = path;
            }
        }
    }

    private class RunOnFameActivationAction
    extends AnAction {
        private RunOnFameActivationAction() {
            super("Run On Frame Activation", "", IconLoader.getIcon((String)"/general/run.png"));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner == null);
        }

        public void actionPerformed(AnActionEvent e) {
            PlaybackDebugger.this.runOnFrame();
        }
    }

    private class ActivateFrameAndRun
    extends AnAction {
        private ActivateFrameAndRun() {
            super("Activate Frame And Run", "", IconLoader.getIcon((String)"/nodes/deploy.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            PlaybackDebugger.this.activateAndRun();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner == null);
        }
    }

    private class StopAction
    extends AnAction {
        private StopAction() {
            super("Stop", null, IconLoader.getIcon((String)"/actions/suspend.png"));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PlaybackDebugger.this.myRunner != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (PlaybackDebugger.this.myRunner != null) {
                PlaybackDebugger.this.myRunner.stop();
                PlaybackDebugger.this.myRunner = null;
            }
        }
    }

    private class SetScriptFileAction
    extends AnAction {
        FileChooserDescriptor descriptor;

        private SetScriptFileAction() {
            super("Set Script File", "", IconLoader.getIcon((String)"/nodes/packageOpen.png"));
            this.descriptor = new ScriptFileChooserDescriptor();
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile[] files = FileChooser.chooseFiles((Component)PlaybackDebugger.this.myComponent, (FileChooserDescriptor)this.descriptor);
            if (files.length > 0) {
                VirtualFile selectedFile = files[0];
                PlaybackDebugger.this.myCurrentScript.setText(selectedFile.getPresentableUrl());
                PlaybackDebugger.this.loadFrom(selectedFile);
                ((PlaybackDebugger)PlaybackDebugger.this).myState.currentScript = selectedFile.getPresentableUrl();
            }
        }
    }

    private static class ScriptFileChooserDescriptor
    extends FileChooserDescriptor {
        public ScriptFileChooserDescriptor() {
            super(true, false, false, false, false, false);
            this.putUserData(FileChooserKeys.NEW_FILE_TYPE, UiScriptFileType.getInstance());
            this.putUserData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT, "");
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            if (!showHiddenFiles && FileElement.isFileHidden((VirtualFile)file)) {
                return false;
            }
            return file.getExtension() != null && file.getExtension().equalsIgnoreCase(PlaybackDebugger.EXT) || super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
        }
    }

    private class SaveAction
    extends AnAction {
        private SaveAction() {
            super("Save", "", IconLoader.getIcon((String)"/actions/menu-saveall.png"));
        }

        public void update(AnActionEvent e) {
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    PlaybackDebugger.this.save();
                }
            });
        }
    }
}

