/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class UsefulTestCase
extends TestCase {
    protected final Disposable myTestRootDisposable = Disposer.newDisposable();
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static CodeStyleSettings myOldCodeStyleSettings;
    protected static final Key<String> CREATION_PLACE;

    protected void tearDown() throws Exception {
        Disposer.dispose((Disposable)this.myTestRootDisposable);
        UsefulTestCase.cleanupSwingDataStructures();
        super.tearDown();
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Class<?> aClass = Class.forName("javax.swing.KeyboardManager");
        Method get = aClass.getMethod("getCurrentManager", new Class[0]);
        get.setAccessible(true);
        Object manager = get.invoke(null, new Object[0]);
        Field mapF = aClass.getDeclaredField("componentKeyStrokeMap");
        mapF.setAccessible(true);
        Object map = mapF.get(manager);
        ((Map)map).clear();
        mapF = aClass.getDeclaredField("containerMap");
        mapF.setAccessible(true);
        map = mapF.get(manager);
        ((Map)map).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForSettingsDamage() throws Exception {
        if (this.isPerformanceTest() || ApplicationManager.getApplication() == null) {
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        try {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Assert.assertEquals((String)"Code insight settings damaged", (String)DEFAULT_SETTINGS_EXTERNALIZED, (String)JDOMUtil.writeElement((Element)newS, (String)"\n"));
        }
        catch (AssertionError error) {
            CodeInsightSettings clean = new CodeInsightSettings();
            Element temp = new Element("temp");
            clean.writeExternal(temp);
            settings.loadState(temp);
            throw error;
        }
        CodeStyleSettings codeStyleSettings = this.getCurrentCodeStyleSettings();
        codeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        try {
            UsefulTestCase.checkSettingsEqual((JDOMExternalizable)myOldCodeStyleSettings, (JDOMExternalizable)codeStyleSettings, "Code style settings damaged");
        }
        finally {
            codeStyleSettings.clearCodeStyleSettings();
        }
        myOldCodeStyleSettings = null;
        VariableInplaceRenamer.checkCleared();
    }

    protected void storeSettings() {
        if (!this.isPerformanceTest() && ApplicationManager.getApplication() != null) {
            myOldCodeStyleSettings = this.getCurrentCodeStyleSettings().clone();
            myOldCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        }
    }

    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyleSettingsManager.getInstance().getCurrentSettings();
    }

    protected Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    @NonNls
    public static String toString(Collection<?> collection) {
        if (collection.isEmpty()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((Collection)o));
            } else {
                builder.append(o);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static <T> void assertOrderedEquals(T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    public static <T> void assertOrderedEquals(Collection<T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static <T> void assertOrderedEquals(String errorMsg, Collection<T> actual, T ... expected) {
        Assert.assertNotNull(actual);
        Assert.assertNotNull(expected);
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(Collection<? extends T> actual, Collection<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static <T> void assertOrderedEquals(String erroMsg, Collection<? extends T> actual, Collection<? extends T> expected) {
        if (!new ArrayList<T>(actual).equals(new ArrayList<T>(expected))) {
            Assert.assertEquals((String)erroMsg, (String)UsefulTestCase.toString(expected), (String)UsefulTestCase.toString(actual));
            Assert.fail();
        }
    }

    public static <T> void assertOrderedCollection(T[] collection, Consumer<T> ... checkers) {
        Assert.assertNotNull(collection);
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertSameElements(T[] collection, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(collection), expected);
    }

    public static <T> void assertSameElements(Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertSameElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(Collection<? extends T> collection, Collection<T> expected) {
        if (collection.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(collection))) {
            Assert.assertEquals((String)UsefulTestCase.toString(expected, "\n"), (String)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals(new HashSet<T>(expected), new HashSet<T>(collection));
        }
    }

    public static String toString(Object[] collection, String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    public static String toString(Collection<?> collection, String separator) {
        List list = ContainerUtil.map2List(collection, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return String.valueOf(o);
            }
        });
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    public static <T> void assertOrderedCollection(Collection<? extends T> collection, Consumer<T> ... checkers) {
        Assert.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    public static <T> void assertUnorderedCollection(T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertUnorderedCollection(Collection<? extends T> collection, Consumer<T> ... checkers) {
        Assert.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer : checkerSet) {
                Throwable error = UsefulTestCase.accepts(consumer, actual);
                if (error == null) {
                    checkerSet.remove(consumer);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(Consumer<T> condition, T actual) {
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public static <T> T assertInstanceOf(Object o, Class<T> aClass) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)o.getClass().getName(), (boolean)aClass.isInstance(o));
        return (T)o;
    }

    public static <T> T assertOneElement(Collection<T> collection) {
        Assert.assertNotNull(collection);
        Assert.assertEquals((String)UsefulTestCase.toString(collection), (int)1, (int)collection.size());
        return collection.iterator().next();
    }

    public static <T> T assertOneElement(T[] ts) {
        Assert.assertNotNull(ts);
        Assert.assertEquals((int)1, (int)ts.length);
        return ts[0];
    }

    public static void printThreadDump() {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            StackTraceElement[] value;
            System.out.println("\n" + entry.getKey().getName() + "\n");
            for (StackTraceElement stackTraceElement : value = entry.getValue()) {
                System.out.println(" at " + stackTraceElement);
            }
        }
    }

    public static void assertEmpty(Object[] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertEmpty(Collection<?> collection) {
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static void assertEmpty(String errorMsg, Collection<?> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, new Object[0]);
    }

    public static void assertSize(int expectedSize, Object[] array) {
        UsefulTestCase.assertEquals((int)expectedSize, (int)array.length);
    }

    public static void assertSize(int expectedSize, Collection<?> c) {
        UsefulTestCase.assertEquals((int)expectedSize, (int)c.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myTestRootDisposable, disposable);
        return disposable;
    }

    public static void assertSameLines(String expected, String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((String)expectedText, (String)actualText);
    }

    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        if (StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test")))) {
            return "";
        }
        return UsefulTestCase.getTestName(name, lowercaseFirstLetter);
    }

    public static String getTestName(String name, boolean lowercaseFirstLetter) {
        if (lowercaseFirstLetter && !UsefulTestCase.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public static boolean isAllUppercaseName(String name) {
        int uppercaseChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLowerCase(name.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    protected static void assertSameLinesWithFile(String filePath, String actualText) {
        String fileText;
        try {
            FileReader reader = new FileReader(filePath);
            fileText = FileUtil.loadTextAndClose((Reader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UsefulTestCase.assertSameLines(fileText, actualText);
    }

    public static void clearFields(Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(Object test, Class aClass) throws IllegalAccessException {
        if (aClass == null) {
            return;
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    protected static void checkSettingsEqual(JDOMExternalizable expected, JDOMExternalizable settings, String message) throws Exception {
        if (expected == null) {
            return;
        }
        if (settings == null) {
            return;
        }
        Element oldS = new Element("temp");
        expected.writeExternal(oldS);
        Element newS = new Element("temp");
        settings.writeExternal(newS);
        String newString = JDOMUtil.writeElement((Element)newS, (String)"\n");
        String oldString = JDOMUtil.writeElement((Element)oldS, (String)"\n");
        Assert.assertEquals((String)message, (String)oldString, (String)newString);
    }

    public boolean isPerformanceTest() {
        String name = this.getName();
        return name != null && name.contains("Performance") || ((Object)((Object)this)).getClass().getName().contains("Performance");
    }

    public static void doPostponedFormatting(final Project project) {
        try {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                            PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimersAreDisposed() {
        block5: {
            try {
                Class<?> aClass = Class.forName("javax.swing.TimerQueue");
                Method inst = aClass.getDeclaredMethod("sharedInstance", new Class[0]);
                inst.setAccessible(true);
                Object queue = inst.invoke(null, new Object[0]);
                Field field = aClass.getDeclaredField("firstTimer");
                field.setAccessible(true);
                Object firstTimer = field.get(queue);
                if (firstTimer == null) break block5;
                try {
                    UsefulTestCase.fail((String)("Not disposed Timer: " + firstTimer.toString() + "; queue:" + queue));
                }
                finally {
                    field.set(queue, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void assertException(AbstractExceptionCase exceptionCase) throws Throwable {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) throws Throwable {
        this.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    protected void assertNoException(AbstractExceptionCase exceptionCase) throws Throwable {
        this.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExceptionOccurred(boolean shouldOccur, AbstractExceptionCase exceptionCase, String expectedErrorMsg) throws Throwable {
        block9: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                if (shouldOccur) {
                    wasThrown = true;
                    String errorMessage = exceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)errorMessage, exceptionCase.getExpectedExceptionClass(), e.getClass());
                    if (expectedErrorMsg != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)expectedErrorMsg, (String)e.getMessage());
                    }
                    break block9;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(e.getClass())) {
                    wasThrown = true;
                    System.out.println("");
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + e.getMessage()));
                    break block9;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)exceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    static {
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            CodeInsightSettings defaultSettings = new CodeInsightSettings();
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS, (String)"\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

