/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class DocCommentPanel
extends JPanel {
    private JRadioButton myRbJavaDocAsIs = null;
    private JRadioButton myRbJavaDocMove = null;
    private JRadioButton myRbJavaDocCopy = null;
    private final TitledBorder myBorder;

    public DocCommentPanel(String title) {
        this.setLayout(new BoxLayout(this, 1));
        this.myBorder = IdeBorderFactory.createTitledBorder((String)title);
        this.setBorder(this.myBorder);
        this.myRbJavaDocAsIs = new JRadioButton();
        this.myRbJavaDocAsIs.setText(RefactoringBundle.message((String)"javadoc.as.is"));
        this.add(this.myRbJavaDocAsIs);
        this.myRbJavaDocAsIs.setFocusable(false);
        this.myRbJavaDocCopy = new JRadioButton();
        this.myRbJavaDocCopy.setText(RefactoringBundle.message((String)"javadoc.copy"));
        this.myRbJavaDocCopy.setFocusable(false);
        this.add(this.myRbJavaDocCopy);
        this.myRbJavaDocMove = new JRadioButton();
        this.myRbJavaDocMove.setText(RefactoringBundle.message((String)"javadoc.move"));
        this.myRbJavaDocMove.setFocusable(false);
        this.add(this.myRbJavaDocMove);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myRbJavaDocAsIs);
        bg.add(this.myRbJavaDocCopy);
        bg.add(this.myRbJavaDocMove);
        bg.setSelected(this.myRbJavaDocMove.getModel(), true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension borderSize = this.myBorder.getMinimumSize(this);
        return new Dimension(Math.max(preferredSize.width, borderSize.width + 10), Math.max(preferredSize.height, borderSize.height));
    }

    public void setPolicy(int javaDocPolicy) {
        if (javaDocPolicy == 2) {
            this.myRbJavaDocCopy.setSelected(true);
        } else if (javaDocPolicy == 1) {
            this.myRbJavaDocMove.setSelected(true);
        } else {
            this.myRbJavaDocAsIs.setSelected(true);
        }
    }

    public int getPolicy() {
        if (this.myRbJavaDocCopy != null && this.myRbJavaDocCopy.isSelected()) {
            return 2;
        }
        if (this.myRbJavaDocMove != null && this.myRbJavaDocMove.isSelected()) {
            return 1;
        }
        return 0;
    }
}

