/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil");

    private MoveFilesOrDirectoriesUtil() {
    }

    public static void doMoveDirectory(PsiDirectory aDirectory, PsiDirectory destDirectory) throws IncorrectOperationException {
        PsiManager manager = aDirectory.getManager();
        manager.moveDirectory(aDirectory, destDirectory);
    }

    public static void doMoveFile(PsiFile file, PsiDirectory newDirectory) throws IncorrectOperationException {
        PsiManager manager = file.getManager();
        if (!newDirectory.equals(file.getContainingDirectory())) {
            manager.moveFile(file, newDirectory);
        }
    }

    public static void doMove(final Project project, final PsiElement[] elements, final PsiElement[] targetElement, final MoveCallback moveCallback) {
        for (PsiElement element : elements) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) continue;
            throw new IllegalArgumentException("unexpected element type: " + element);
        }
        PsiDirectory targetDirectory = MoveFilesOrDirectoriesUtil.resolveToDirectory(project, targetElement[0]);
        if (targetElement[0] != null && targetDirectory == null) {
            return;
        }
        PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(targetDirectory, elements);
        MoveFilesOrDirectoriesDialog.Callback doRun = new MoveFilesOrDirectoriesDialog.Callback(){

            @Override
            public void run(final MoveFilesOrDirectoriesDialog moveDialog) {
                PsiDirectory targetDirectory = moveDialog.getTargetDirectory();
                LOG.assertTrue(targetDirectory != null);
                targetElement[0] = targetDirectory;
                PsiManager manager = PsiManager.getInstance((Project)project);
                try {
                    for (PsiElement psiElement : elements) {
                        manager.checkMove(psiElement, (PsiElement)targetDirectory);
                    }
                    new MoveFilesOrDirectoriesProcessor(project, elements, targetDirectory, false, false, moveCallback, new Runnable(){

                        @Override
                        public void run() {
                            moveDialog.close(1);
                        }
                    }).run();
                }
                catch (IncorrectOperationException e) {
                    CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)"refactoring.moveFile", (Project)project);
                }
            }
        };
        MoveFilesOrDirectoriesDialog moveDialog = new MoveFilesOrDirectoriesDialog(project, doRun);
        moveDialog.setData(elements, initialTargetDirectory, "refactoring.moveFile");
        moveDialog.show();
    }

    @Nullable
    private static PsiDirectory resolveToDirectory(Project project, PsiElement element) {
        if (!(element instanceof PsiDirectoryContainer)) {
            return (PsiDirectory)element;
        }
        PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
        switch (directories.length) {
            case 0: {
                return null;
            }
            case 1: {
                return directories[0];
            }
        }
        return DirectoryChooserUtil.chooseDirectory(directories, directories[0], project, new HashMap<PsiDirectory, String>());
    }

    @Nullable
    private static PsiDirectory getCommonDirectory(PsiElement[] movedElements) {
        PsiDirectory commonDirectory = null;
        for (PsiElement movedElement : movedElements) {
            PsiDirectory containingDirectory;
            if (movedElement instanceof PsiDirectory) {
                containingDirectory = ((PsiDirectory)movedElement).getParentDirectory();
            } else {
                PsiFile containingFile = movedElement.getContainingFile();
                PsiDirectory psiDirectory = containingDirectory = containingFile == null ? null : containingFile.getContainingDirectory();
            }
            if (containingDirectory == null) continue;
            if (commonDirectory == null) {
                commonDirectory = containingDirectory;
                continue;
            }
            if (commonDirectory == containingDirectory) continue;
            return null;
        }
        return commonDirectory;
    }

    @Nullable
    private static PsiDirectory getInitialTargetDirectory(PsiDirectory initialTargetElement, PsiElement[] movedElements) {
        PsiDirectory initialTargetDirectory = initialTargetElement;
        if (initialTargetDirectory == null && movedElements != null) {
            PsiDirectory commonDirectory = MoveFilesOrDirectoriesUtil.getCommonDirectory(movedElements);
            initialTargetDirectory = commonDirectory != null ? commonDirectory : MoveFilesOrDirectoriesUtil.getContainerDirectory(movedElements[0]);
        }
        return initialTargetDirectory;
    }

    @Nullable
    private static PsiDirectory getContainerDirectory(PsiElement psiElement) {
        if (psiElement instanceof PsiDirectory) {
            return (PsiDirectory)psiElement;
        }
        if (psiElement != null) {
            return psiElement.getContainingFile().getContainingDirectory();
        }
        return null;
    }
}

