/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

class MoveClassesOrPackagesViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myPsiElements;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private final String myNewParentPackageName;
    private String myProcessedElementsHeader;
    private final String myCodeReferencesText;

    public MoveClassesOrPackagesViewDescriptor(PsiElement[] psiElements, boolean isSearchInComments, boolean searchInNonJavaFiles, String targetName) {
        this.myPsiElements = psiElements;
        this.mySearchInComments = isSearchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myNewParentPackageName = targetName;
        if (psiElements.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.single.element.elements.header", (Object[])new Object[]{UsageViewUtil.getType(psiElements[0]), this.myNewParentPackageName}));
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.in.code.to.0.1", (Object[])new Object[]{UsageViewUtil.getType(psiElements[0]), UsageViewUtil.getLongName(psiElements[0])});
        } else {
            if (psiElements.length > 0) {
                if (psiElements[0] instanceof PsiClass) {
                    this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.classes.elements.header", (Object[])new Object[]{this.myNewParentPackageName}));
                } else if (psiElements[0] instanceof PsiDirectory) {
                    this.myProcessedElementsHeader = StringUtil.capitalize((String)RefactoringBundle.message((String)"move.packages.elements.header", (Object[])new Object[]{this.myNewParentPackageName}));
                }
            }
            this.myCodeReferencesText = RefactoringBundle.message((String)"references.found.in.code");
        }
    }

    @NotNull
    public PsiElement[] getElements() {
        if (this.myPsiElements == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesViewDescriptor.getElements must not return null");
        }
        return this.myPsiElements;
    }

    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return this.myCodeReferencesText + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
    }
}

