/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;

public class InputValidator
implements IntroduceVariableBase.Validator {
    private final Project myProject;
    private final PsiElement myAnchorStatementIfAll;
    private final PsiElement myAnchorStatement;
    private final ExpressionOccurenceManager myOccurenceManager;
    private final IntroduceVariableBase myIntroduceVariableBase;

    @Override
    public boolean isOK(IntroduceVariableSettings settings) {
        String name = settings.getEnteredName();
        boolean replaceAllOccurrences = settings.isReplaceAllOccurrences();
        PsiElement anchor = replaceAllOccurrences ? this.myAnchorStatementIfAll : this.myAnchorStatement;
        PsiElement scope = anchor.getParent();
        if (scope == null) {
            return true;
        }
        final MultiMap conflicts = new MultiMap();
        final HashSet reportedVariables = new HashSet();
        JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor visitor = new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){

            @Override
            public void visitCollidingElement(PsiVariable collidingVariable) {
                if (!reportedVariables.contains((Object)collidingVariable)) {
                    reportedVariables.add((Object)collidingVariable);
                    String message = RefactoringBundle.message((String)"introduced.variable.will.conflict.with.0", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)collidingVariable, true)});
                    conflicts.putValue((Object)collidingVariable, (Object)message);
                }
            }
        };
        JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions(anchor, name, scope, anchor, visitor);
        if (replaceAllOccurrences) {
            PsiExpression[] occurences;
            for (PsiExpression occurence : occurences = this.myOccurenceManager.getOccurences()) {
                IntroduceVariableBase.checkInLoopCondition(occurence, (MultiMap<PsiElement, String>)conflicts);
            }
        } else {
            IntroduceVariableBase.checkInLoopCondition(this.myOccurenceManager.getMainOccurence(), (MultiMap<PsiElement, String>)conflicts);
        }
        if (conflicts.size() > 0) {
            return this.myIntroduceVariableBase.reportConflicts((MultiMap<PsiElement, String>)conflicts, this.myProject, settings);
        }
        return true;
    }

    public InputValidator(IntroduceVariableBase introduceVariableBase, Project project, PsiElement anchorStatementIfAll, PsiElement anchorStatement, ExpressionOccurenceManager occurenceManager) {
        this.myIntroduceVariableBase = introduceVariableBase;
        this.myProject = project;
        this.myAnchorStatementIfAll = anchorStatementIfAll;
        this.myAnchorStatement = anchorStatement;
        this.myOccurenceManager = occurenceManager;
    }
}

