/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.EnclosingMethodSelectionDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.usageView.UsageInfo;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterHandler
extends IntroduceHandlerBase
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private Project myProject;

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, "refactoring.introduceParameter", project, new Pass<ElementToWorkOn>(){

            public void pass(ElementToWorkOn elementToWorkOn) {
                boolean isInvokedOnDeclaration;
                PsiLocalVariable localVar;
                if (elementToWorkOn == null) {
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                if (IntroduceParameterHandler.this.invoke(editor, project, expr, localVar = elementToWorkOn.getLocalVariable(), isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration())) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project, final PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiElement resolved;
        PsiType typeByExpression;
        String message;
        PsiElement physicalElement;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments());
        PsiMethod method = expr != null ? Util.getContainingMethod((PsiElement)((physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT)) != null ? physicalElement : expr)) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        this.myProject = project;
        if (expr == null && localVar == null) {
            message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            IntroduceParameterHandler.showErrorMessage(this.myProject, message, editor);
            return false;
        }
        if (method == null) {
            message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            IntroduceParameterHandler.showErrorMessage(this.myProject, message, editor);
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (!invokedOnDeclaration && typeByExpression == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined"));
            IntroduceParameterHandler.showErrorMessage(this.myProject, message2, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiType.VOID.equals(typeByExpression)) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            IntroduceParameterHandler.showErrorMessage(project, message3, editor);
            return false;
        }
        if ((method = IntroduceParameterHandler.chooseEnclosingMethod(method)) == null) {
            return false;
        }
        PsiMethod methodToSearchFor = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
        if (methodToSearchFor == null) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)methodToSearchFor)) {
            return false;
        }
        PsiExpression expressionToRemoveParamFrom = expr;
        if (expr == null) {
            expressionToRemoveParamFrom = localVar.getInitializer();
        }
        TIntArrayList parametersToRemove = expressionToRemoveParamFrom == null ? new TIntArrayList() : Util.findParametersToRemove(method, expressionToRemoveParamFrom);
        PsiExpression[] occurences = expr != null ? new ExpressionOccurenceManager(expr, (PsiElement)method, null).findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method, (PsiElement)localVar);
        if (editor != null) {
            RefactoringUtil.highlightAllOccurences(this.myProject, (PsiElement[])occurences, editor);
        }
        boolean mustBeFinal = false;
        if (localVar != null) {
            for (PsiExpression occurrence : occurences) {
                if (PsiTreeUtil.getParentOfType((PsiElement)occurrence, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method) continue;
                mustBeFinal = true;
                break;
            }
        }
        ArrayList<UsageInfo> localVars = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> classMemberRefs = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> params = new ArrayList<UsageInfo>();
        if (expr != null) {
            Util.analyzeExpression(expr, localVars, classMemberRefs, params);
        }
        if (expr instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable) {
            localVar = (PsiLocalVariable)resolved;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String parameterName = "anObject";
            boolean replaceAllOccurences = true;
            boolean isDeleteLocalVariable = true;
            PsiExpression initializer = localVar != null && expr == null ? localVar.getInitializer() : expr;
            new IntroduceParameterProcessor(this.myProject, method, methodToSearchFor, initializer, expr, localVar, isDeleteLocalVariable, parameterName, replaceAllOccurences, 0, mustBeFinal, false, null, parametersToRemove).run();
        } else {
            final String propName = localVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(localVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, expr, localVar);
            TypeSelectorManagerImpl typeSelectorManager = expr != null ? new TypeSelectorManagerImpl(project, initializerType, expr, occurences) : new TypeSelectorManagerImpl(project, initializerType, occurences);
            NameSuggestionsGenerator nameSuggestionsGenerator = new NameSuggestionsGenerator(){

                @Override
                public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)IntroduceParameterHandler.this.myProject);
                    SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr, type);
                    String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, info);
                    return new SuggestedNameInfo.Delegate(strings, info);
                }
            };
            new IntroduceParameterDialog(this.myProject, classMemberRefs, occurences.length, localVar, expr, nameSuggestionsGenerator, typeSelectorManager, methodToSearchFor, method, parametersToRemove, mustBeFinal).show();
        }
        return true;
    }

    private static void showErrorMessage(Project project, String message, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterHandler.invoke must not be null");
        }
    }

    private static List<PsiMethod> getEnclosingMethods(PsiMethod nearest) {
        ArrayList<PsiMethod> enclosingMethods = new ArrayList<PsiMethod>();
        enclosingMethods.add(nearest);
        PsiMethod method = nearest;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true)) != null) {
            enclosingMethods.add(method);
        }
        if (enclosingMethods.size() > 1) {
            ArrayList<PsiMethod> methodsNotImplementingLibraryInterfaces = new ArrayList<PsiMethod>();
            for (PsiMethod enclosing : enclosingMethods) {
                PsiMethod[] superMethods = enclosing.findDeepestSuperMethods();
                boolean libraryInterfaceMethod = false;
                for (PsiMethod superMethod : superMethods) {
                    libraryInterfaceMethod |= IntroduceParameterHandler.isLibraryInterfaceMethod(superMethod);
                }
                if (libraryInterfaceMethod) continue;
                methodsNotImplementingLibraryInterfaces.add(enclosing);
            }
            if (methodsNotImplementingLibraryInterfaces.size() > 0) {
                return methodsNotImplementingLibraryInterfaces;
            }
        }
        return enclosingMethods;
    }

    @Nullable
    public static PsiMethod chooseEnclosingMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/IntroduceParameterHandler.chooseEnclosingMethod must not be null");
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            EnclosingMethodSelectionDialog dialog = new EnclosingMethodSelectionDialog(method.getProject(), validEnclosingMethods);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            method = dialog.getSelectedMethod();
        } else if (validEnclosingMethods.size() == 1) {
            method = validEnclosingMethods.get(0);
        }
        return method;
    }

    private static boolean isLibraryInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !method.getManager().isInProject((PsiElement)method);
    }
}

