/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TestUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;

public class LocalToFieldHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.LocalToFieldHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"convert.local.to.field.title");
    private final Project myProject;
    private final boolean myIsConstant;
    private final PsiManager myManager;

    public LocalToFieldHandler(Project project, boolean isConstant) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myIsConstant = isConstant;
    }

    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurences, boolean isStatic) {
        boolean introduceEnumConstant;
        boolean annotateAsNonNls;
        String fieldVisibility;
        BaseExpressionToFieldHandler.InitializationPlace initializerPlace;
        boolean declareFinal;
        String fieldName;
        TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(this.myProject, local.getType(), occurences);
        if (this.myIsConstant) {
            IntroduceConstantDialog dialog = new IntroduceConstantDialog(this.myProject, aClass, local.getInitializer(), local, true, occurences, aClass, typeSelectorManager);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            fieldName = dialog.getEnteredName();
            declareFinal = true;
            initializerPlace = BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
            fieldVisibility = dialog.getFieldVisibility();
            annotateAsNonNls = dialog.isAnnotateAsNonNls();
            introduceEnumConstant = dialog.introduceEnumConstant();
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)local, PsiMethod.class);
            IntroduceFieldDialog dialog = new IntroduceFieldDialog(this.myProject, aClass, local.getInitializer(), local, method != null && method.isConstructor(), true, isStatic, occurences.length, method != null, method != null, typeSelectorManager);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            fieldName = dialog.getEnteredName();
            initializerPlace = dialog.getInitializerPlace();
            declareFinal = dialog.isDeclareFinal();
            fieldVisibility = dialog.getFieldVisibility();
            annotateAsNonNls = false;
            introduceEnumConstant = false;
        }
        return new BaseExpressionToFieldHandler.Settings(fieldName, true, isStatic, declareFinal, initializerPlace, fieldVisibility, local, null, true, new BaseExpressionToFieldHandler.TargetDestination(aClass), annotateAsNonNls, introduceEnumConstant);
    }

    public boolean convertLocalToField(final PsiLocalVariable local, Editor editor) {
        BaseExpressionToFieldHandler.Settings settings;
        boolean tempIsStatic = this.myIsConstant;
        PsiElement parent = local.getParent();
        while (true) {
            if (parent instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) break;
            if (parent instanceof PsiFile && JspPsiUtil.isInJspFile((PsiElement)parent)) {
                String message = RefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.convertLocal");
                return false;
            }
            if (parent instanceof PsiModifierListOwner && ((PsiModifierListOwner)parent).hasModifierProperty("static")) {
                tempIsStatic = true;
            }
            parent = parent.getParent();
        }
        PsiClass aClass = (PsiClass)parent;
        final boolean isStatic = tempIsStatic;
        final PsiExpression[] occurences = CodeInsightUtil.findReferenceExpressions(RefactoringUtil.getVariableScope(local), (PsiElement)local);
        if (editor != null) {
            RefactoringUtil.highlightAllOccurences(this.myProject, (PsiElement[])occurences, editor);
        }
        if ((settings = this.showRefactoringDialog(aClass, local, occurences, isStatic)) == null) {
            return false;
        }
        final String variableName = local.getName();
        final String fieldName = settings.getFieldName();
        final BaseExpressionToFieldHandler.InitializationPlace initializerPlace = settings.getInitializerPlace();
        PsiClass destinationClass = settings.getDestinationClass();
        boolean rebindNeeded = false;
        if (destinationClass != null) {
            aClass = destinationClass;
            rebindNeeded = true;
        }
        final PsiClass aaClass = aClass;
        final boolean rebindNeeded1 = rebindNeeded;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PsiStatement statement;
                    boolean rebindNeeded2 = !variableName.equals(fieldName) || rebindNeeded1;
                    PsiReference[] refs = rebindNeeded2 ? (PsiReference[])ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.projectScope((Project)LocalToFieldHandler.this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]) : null;
                    PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(aaClass, (PsiElement)local);
                    PsiEnumConstant field = settings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(aaClass, local, fieldName) : LocalToFieldHandler.this.createField(local, fieldName, initializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
                    field = (PsiField)aaClass.add((PsiElement)field);
                    BaseExpressionToFieldHandler.setModifiers((PsiField)field, settings, isStatic, occurences);
                    if (!settings.isIntroduceEnumConstant()) {
                        VisibilityUtil.fixVisibility((PsiExpression[])occurences, (PsiMember)field, (String)settings.getFieldVisibility());
                    }
                    local.normalizeDeclaration();
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)local.getParent();
                    BaseExpressionToFieldHandler.InitializationPlace finalInitializerPlace = local.getInitializer() == null ? BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION : initializerPlace;
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)LocalToFieldHandler.this.myManager.getProject()).getElementFactory();
                    switch (finalInitializerPlace) {
                        case IN_FIELD_DECLARATION: {
                            declarationStatement.delete();
                            break;
                        }
                        case IN_CURRENT_METHOD: {
                            statement = LocalToFieldHandler.this.createAssignment(local, fieldName, factory);
                            declarationStatement.replace((PsiElement)statement);
                            break;
                        }
                        case IN_CONSTRUCTOR: {
                            LocalToFieldHandler.this.addInitializationToConstructors(local, (PsiField)field, enclosingConstructor, factory);
                            break;
                        }
                        case IN_SETUP_METHOD: {
                            LocalToFieldHandler.this.addInitializationToSetUp(local, (PsiField)field, factory);
                        }
                    }
                    if (enclosingConstructor != null && initializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
                        statement = LocalToFieldHandler.this.createAssignment(local, fieldName, factory);
                        declarationStatement.replace((PsiElement)statement);
                    }
                    if (rebindNeeded2) {
                        for (PsiReference reference : refs) {
                            if (reference == null) continue;
                            RefactoringUtil.replaceOccurenceWithFieldRef((PsiExpression)reference, (PsiField)field, aaClass);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, REFACTORING_NAME, null);
        return true;
    }

    private PsiField createField(PsiLocalVariable local, String fieldName, boolean includeInitializer) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (local.getInitializer() == null) {
            includeInitializer = false;
        }
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        try {
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            field = (PsiField)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)field);
            field.getTypeElement().replace((PsiElement)factory.createTypeElement(local.getType()));
            if (includeInitializer) {
                PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), local.getType());
                field.getInitializer().replace((PsiElement)initializer);
            }
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiStatement createAssignment(PsiLocalVariable local, String fieldname, PsiElementFactory factory) {
        try {
            String pattern = fieldname + "=0;";
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
            PsiAssignmentExpression expr = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), local.getType());
            expr.getRExpression().replace((PsiElement)initializer);
            return statement;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private void addInitializationToSetUp(PsiLocalVariable local, PsiField field, PsiElementFactory factory) throws IncorrectOperationException {
        PsiMethod inClass = TestUtil.findSetUpMethod((PsiClass)field.getContainingClass());
        assert (inClass != null);
        PsiStatement assignment = this.createAssignment(local, field.getName(), factory);
        PsiCodeBlock body = inClass.getBody();
        assert (body != null);
        body.add((PsiElement)assignment);
        local.delete();
    }

    private void addInitializationToConstructors(PsiLocalVariable local, PsiField field, PsiMethod enclosingConstructor, PsiElementFactory factory) throws IncorrectOperationException {
        PsiClass aClass = field.getContainingClass();
        PsiMethod[] constructors = aClass.getConstructors();
        PsiStatement assignment = this.createAssignment(local, field.getName(), factory);
        boolean added = false;
        for (PsiMethod constructor : constructors) {
            String text;
            PsiExpression expression;
            PsiStatement first;
            PsiStatement[] statements;
            PsiCodeBlock body;
            if (constructor == enclosingConstructor || (body = constructor.getBody()) == null || (statements = body.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText())) continue;
            body.add((PsiElement)assignment);
            added = true;
        }
        if (!added && enclosingConstructor == null) {
            PsiMethod constructor = factory.createConstructor();
            constructor.getBody().add((PsiElement)assignment);
            aClass.add((PsiElement)constructor);
        }
        if (enclosingConstructor == null) {
            local.delete();
        }
    }
}

