/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;

public class ChangeSignatureUtil {
    private ChangeSignatureUtil() {
    }

    public static <Parent extends PsiElement, Child extends PsiElement> void synchronizeList(Parent list, List<Child> newElements, ChildrenGenerator<Parent, Child> generator, boolean[] shouldRemoveChild) throws IncorrectOperationException {
        List<Child> elements;
        ArrayList<Child> elementsToRemove = null;
        int index = 0;
        while (true) {
            elements = generator.getChildren(list);
            if (index == newElements.size()) break;
            if (elementsToRemove == null) {
                elementsToRemove = new ArrayList<Child>();
                for (int i = 0; i < shouldRemoveChild.length; ++i) {
                    if (!shouldRemoveChild[i] || i >= elements.size()) continue;
                    elementsToRemove.add(elements.get(i));
                }
            }
            PsiElement oldElement = index < elements.size() ? (PsiElement)elements.get(index) : null;
            PsiElement newElement = (PsiElement)newElements.get(index);
            if (!newElement.equals(oldElement)) {
                if (oldElement != null && elementsToRemove.contains(oldElement)) {
                    oldElement.delete();
                    --index;
                } else {
                    assert (list.isWritable()) : PsiUtilBase.getVirtualFile(list);
                    list.addBefore(newElement, oldElement);
                    if (list.equals(newElement.getParent())) {
                        newElement.delete();
                    }
                }
            }
            ++index;
        }
        for (int i = newElements.size(); i < elements.size(); ++i) {
            PsiElement element = (PsiElement)elements.get(i);
            element.delete();
        }
    }

    public static interface ChildrenGenerator<Parent extends PsiElement, Child extends PsiElement> {
        public List<Child> getChildren(Parent var1);
    }
}

