/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.IntroduceHandlerBase");

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/IntroduceHandlerBase.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/IntroduceHandlerBase.invoke must not be null");
        }
        LOG.assertTrue(elements.length >= 1 && elements[0] instanceof PsiExpression, (Object)"incorrect invoke() parameters");
        PsiElement tempExpr = elements[0];
        if (dataContext != null) {
            Editor editorFromDC = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
            PsiFile cachedPsiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editorFromDC.getDocument());
            editor = cachedPsiFile != null && PsiTreeUtil.isAncestor((PsiElement)cachedPsiFile, (PsiElement)tempExpr, (boolean)false) ? editorFromDC : null;
        } else {
            editor = null;
        }
        if (tempExpr instanceof PsiExpression) {
            this.invokeImpl(project, (PsiExpression)tempExpr, editor);
        } else if (tempExpr instanceof PsiLocalVariable) {
            this.invokeImpl(project, (PsiLocalVariable)tempExpr, editor);
        } else {
            LOG.error("elements[0] should be PsiExpression or PsiLocalVariable");
        }
    }

    protected abstract boolean invokeImpl(Project var1, PsiExpression var2, Editor var3);

    protected abstract boolean invokeImpl(Project var1, PsiLocalVariable var2, Editor var3);
}

