/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final PackageReferenceSet myReferenceSet;
    private final int myIndex;

    public PsiPackageReference(PackageReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, set.isSoft());
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @Nullable
    private PsiPackage getContext() {
        return this.myIndex == 0 ? JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("") : (PsiPackage)((PsiPackageReference)this.myReferenceSet.getReference(this.myIndex - 1)).resolve();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        PsiPackage psiPackage = this.getContext();
        if (psiPackage == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference.getVariants must not return null");
            return objectArray;
        }
        PsiPackage[] psiPackages = psiPackage.getSubPackages();
        Object[] variants = new Object[psiPackages.length];
        System.arraycopy(psiPackages, 0, variants, 0, variants.length);
        objectArray = variants;
        if (variants != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference.getVariants must not return null");
    }

    public String getUnresolvedMessagePattern() {
        return JavaErrorMessages.message("cannot.resolve.package", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        PsiPackage parentPackage = this.getContext();
        if (parentPackage != null) {
            Collection<PsiPackage> packages = this.myReferenceSet.resolvePackageName(parentPackage, this.getValue());
            resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(packages, ResolveResult.class, (Function)new Function<PsiPackage, ResolveResult>(){

                public ResolveResult fun(PsiPackage psiPackage) {
                    return new PsiElementResolveResult((PsiElement)psiPackage);
                }
            });
            if (resolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference.multiResolve must not return null");
            return resolveResultArray;
        }
        resolveResultArray = ResolveResult.EMPTY_ARRAY;
        if (ResolveResult.EMPTY_ARRAY != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference.multiResolve must not return null");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference.bindToElement must not be null");
        }
        if (!(element instanceof PsiPackage)) {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        String newName = ((PsiPackage)element).getQualifiedName();
        TextRange range = new TextRange(((PsiPackageReference)this.getReferenceSet().getReference(0)).getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.getElement());
        return manipulator.handleContentChange(this.getElement(), range, newName);
    }

    public PackageReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }
}

