/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ResolveCache {
    private static final Key<MapPair<PsiPolyVariantReference, Reference<ResolveResult[]>>> JAVA_RESOLVE_MAP = Key.create((String)"ResolveCache.JAVA_RESOLVE_MAP");
    private static final Key<MapPair<PsiReference, Reference<PsiElement>>> RESOLVE_MAP = Key.create((String)"ResolveCache.RESOLVE_MAP");
    private static final Key<MapPair<PsiPolyVariantReference, Reference<ResolveResult[]>>> JAVA_RESOLVE_MAP_INCOMPLETE = Key.create((String)"ResolveCache.JAVA_RESOLVE_MAP_INCOMPLETE");
    private static final Key<MapPair<PsiReference, Reference<PsiElement>>> RESOLVE_MAP_INCOMPLETE = Key.create((String)"ResolveCache.RESOLVE_MAP_INCOMPLETE");
    private final Map<PsiPolyVariantReference, Reference<ResolveResult[]>>[] myPolyVariantResolveMaps = new Map[4];
    private final Map<PsiReference, Reference<PsiElement>>[] myResolveMaps = new Map[4];
    private final AtomicInteger myClearCount = new AtomicInteger(0);
    private final PsiManagerEx myManager;
    private final List<Runnable> myRunnablesToRunOnDropCaches = ContainerUtil.createEmptyCOWList();
    private static final ArrayFactory<Thread> THREAD_ARRAY_FACTORY = new ArrayFactory<Thread>(){

        public Thread[] create(int count) {
            return new Thread[count];
        }
    };
    private static final Key<Thread[]> IS_BEING_RESOLVED_KEY = Key.create((String)"ResolveCache.IS_BEING_RESOLVED_KEY");

    public ResolveCache(PsiManagerEx manager) {
        this.myManager = manager;
        this.myPolyVariantResolveMaps[0] = this.getOrCreateWeakMap(JAVA_RESOLVE_MAP, true);
        this.myPolyVariantResolveMaps[1] = this.getOrCreateWeakMap(JAVA_RESOLVE_MAP_INCOMPLETE, true);
        this.myResolveMaps[0] = this.getOrCreateWeakMap(RESOLVE_MAP, true);
        this.myResolveMaps[1] = this.getOrCreateWeakMap(RESOLVE_MAP_INCOMPLETE, true);
        this.myPolyVariantResolveMaps[2] = this.getOrCreateWeakMap(JAVA_RESOLVE_MAP, false);
        this.myPolyVariantResolveMaps[3] = this.getOrCreateWeakMap(JAVA_RESOLVE_MAP_INCOMPLETE, false);
        this.myResolveMaps[2] = this.getOrCreateWeakMap(RESOLVE_MAP, false);
        this.myResolveMaps[3] = this.getOrCreateWeakMap(RESOLVE_MAP_INCOMPLETE, false);
    }

    public void clearCache() {
        this.myClearCount.incrementAndGet();
        this.myPolyVariantResolveMaps[0].clear();
        this.myPolyVariantResolveMaps[1].clear();
        this.myResolveMaps[0].clear();
        this.myResolveMaps[1].clear();
        this.myPolyVariantResolveMaps[2].clear();
        this.myPolyVariantResolveMaps[3].clear();
        this.myResolveMaps[2].clear();
        this.myResolveMaps[3].clear();
        for (Runnable r : this.myRunnablesToRunOnDropCaches) {
            r.run();
        }
    }

    public void addRunnableToRunOnDropCaches(Runnable r) {
        this.myRunnablesToRunOnDropCaches.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TRef extends PsiReference, TResult> TResult resolve(TRef ref, AbstractResolver<TRef, TResult> resolver, Map<? super TRef, Reference<TResult>>[] maps, boolean needToPreventRecursion, boolean incompleteCode) {
        ProgressManager.checkCanceled();
        int clearCountOnStart = this.myClearCount.intValue();
        boolean physical = ref.getElement().isPhysical();
        TResult result = ResolveCache.getCached(ref, maps, physical, incompleteCode);
        if (result != null) {
            return result;
        }
        if (incompleteCode && (result = this.resolve(ref, resolver, maps, needToPreventRecursion, false)) != null && (!(result instanceof Object[]) || ((Object[])result).length != 0)) {
            this.cache(ref, result, maps, physical, incompleteCode, clearCountOnStart);
            return result;
        }
        if (needToPreventRecursion && !ResolveCache.lockElement(ref)) {
            return null;
        }
        try {
            result = resolver.resolve(ref, incompleteCode);
        }
        finally {
            if (needToPreventRecursion) {
                ResolveCache.unlockElement(ref);
            }
        }
        this.cache(ref, result, maps, physical, incompleteCode, clearCountOnStart);
        return result;
    }

    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(T ref, PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        ResolveResult[] result = this.resolve(ref, resolver, this.myPolyVariantResolveMaps, needToPreventRecursion, incompleteCode);
        return result == null ? ResolveResult.EMPTY_ARRAY : result;
    }

    public boolean isCached(PsiReference ref) {
        Map<PsiPolyVariantReference, Reference<ResolveResult[]>>[] maps = ref instanceof PsiPolyVariantReference ? this.myPolyVariantResolveMaps : this.myResolveMaps;
        boolean physical = ref.getElement().isPhysical();
        return ResolveCache.getCached(ref, maps, physical, false) != null || ResolveCache.getCached(ref, maps, physical, true) != null;
    }

    public PsiElement resolveWithCaching(PsiReference ref, Resolver resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolve(ref, resolver, this.myResolveMaps, needToPreventRecursion, incompleteCode);
    }

    private static boolean lockElement(PsiReference ref) {
        return ResolveCache.lockElement(ref.getElement(), IS_BEING_RESOLVED_KEY);
    }

    public static boolean lockElement(PsiElement element, Key<Thread[]> key) {
        Thread currentThread = Thread.currentThread();
        while (true) {
            Thread[] newThreads;
            Object[] lockingThreads;
            if ((lockingThreads = (Thread[])element.getUserData(key)) == null) {
                newThreads = new Thread[]{currentThread};
                if (((UserDataHolderEx)element).putUserDataIfAbsent(key, (Object)newThreads) != newThreads) continue;
                break;
            }
            if (ArrayUtil.find((Object[])lockingThreads, (Object)currentThread) != -1) {
                return false;
            }
            newThreads = (Thread[])ArrayUtil.append((Object[])lockingThreads, (Object)currentThread, THREAD_ARRAY_FACTORY);
            if (((UserDataHolderEx)element).replace(key, (Object)lockingThreads, (Object)newThreads)) break;
        }
        Object[] data = (Thread[])element.getUserData(key);
        int i = ArrayUtil.find((Object[])data, (Object)currentThread);
        assert (i != -1);
        assert (i == ArrayUtil.lastIndexOf((Object[])data, (Object)currentThread));
        return true;
    }

    private static void unlockElement(PsiReference ref) {
        ResolveCache.unlockElement(ref.getElement(), IS_BEING_RESOLVED_KEY);
    }

    public static void unlockElement(PsiElement element, Key<Thread[]> key) {
        Object[] newThreads;
        Object[] lockingThreads;
        Thread currentThread = Thread.currentThread();
        do {
            if ((lockingThreads = (Thread[])element.getUserData(key)).length == 1) {
                assert (lockingThreads[0] == currentThread) : "Locking thread = " + lockingThreads[0] + "; current=" + currentThread;
                newThreads = null;
                continue;
            }
            int i = ArrayUtil.find((Object[])lockingThreads, (Object)currentThread);
            assert (i == ArrayUtil.lastIndexOf((Object[])lockingThreads, (Object)currentThread));
            assert (lockingThreads[i] == currentThread);
            newThreads = (Thread[])ArrayUtil.remove((Object[])lockingThreads, (Object)currentThread, THREAD_ARRAY_FACTORY);
            assert (newThreads.length == lockingThreads.length - 1) : "Locking threads = " + Arrays.asList(lockingThreads) + "; newThreads=" + Arrays.asList(newThreads);
            assert (ArrayUtil.find((Object[])newThreads, (Object)currentThread) == -1);
        } while (!((UserDataHolderEx)element).replace(key, (Object)lockingThreads, newThreads));
        Object[] data = (Thread[])element.getUserData(key);
        assert (data == null || ArrayUtil.find((Object[])data, (Object)currentThread) == -1);
    }

    private static int getIndex(boolean physical, boolean incompleteCode) {
        return (physical ? 0 : 1) << 1 | (incompleteCode ? 1 : 0);
    }

    private static <TRef, TResult> TResult getCached(TRef ref, Map<? super TRef, Reference<TResult>>[] maps, boolean physical, boolean incompleteCode) {
        int index = ResolveCache.getIndex(physical, incompleteCode);
        Reference<TResult> reference = maps[index].get(ref);
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    private <TRef extends PsiReference, TResult> void cache(TRef ref, TResult result, Map<? super TRef, Reference<TResult>>[] maps, boolean physical, boolean incompleteCode, int clearCountOnStart) {
        if (clearCountOnStart != this.myClearCount.intValue() && result != null) {
            return;
        }
        int index = ResolveCache.getIndex(physical, incompleteCode);
        maps[index].put(ref, (Reference<TResult>)new SoftReference(result));
    }

    public <K, V> ConcurrentMap<K, V> getOrCreateWeakMap(Key<MapPair<K, V>> key, boolean forPhysical) {
        MapPair pair = (MapPair)this.myManager.getUserData(key);
        if (pair == null) {
            final MapPair _pair = pair = (MapPair)this.myManager.putUserDataIfAbsent(key, new MapPair());
            this.myManager.registerRunnableToRunOnChange(new Runnable(){

                @Override
                public void run() {
                    ResolveCache.this.myClearCount.incrementAndGet();
                    _pair.physicalMap.clear();
                }
            });
            this.myManager.registerRunnableToRunOnAnyChange(new Runnable(){

                @Override
                public void run() {
                    ResolveCache.this.myClearCount.incrementAndGet();
                    _pair.nonPhysicalMap.clear();
                }
            });
        }
        return forPhysical ? pair.physicalMap : pair.nonPhysicalMap;
    }

    public static class MapPair<K, V> {
        public final ConcurrentMap<K, V> physicalMap = new ConcurrentWeakHashMap();
        public final ConcurrentMap<K, V> nonPhysicalMap = new ConcurrentWeakHashMap();
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(TRef var1, boolean var2);
    }
}

