/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBlock
extends AbstractXmlBlock {
    private final Indent myIndent;
    private final TextRange myTextRange;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.XmlBlock");

    public XmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy);
        this.myIndent = indent;
        this.myTextRange = textRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange;
        if (this.myTextRange != null) {
            textRange = this.myTextRange;
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlBlock.getTextRange must not return null");
            return textRange;
        }
        textRange = super.getTextRange();
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlBlock.getTextRange must not return null");
    }

    @Override
    protected List<Block> buildChildren() {
        if (this.myNode.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return this.splitAttribute(this.myNode, this.myXmlFormattingPolicy);
        }
        if (this.myNode.getElementType() == XmlElementType.XML_COMMENT) {
            return this.splitComment();
        }
        if (this.myNode.getElementType() == XmlElementType.XML_TEXT) {
            if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
                return EMPTY;
            }
            ASTNode treeParent = this.myNode.getTreeParent();
            XmlTag tag = XmlBlock.getTag(treeParent);
            if (tag != null && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(tag)) {
                return EMPTY;
            }
        }
        if (this.myNode.getFirstChildNode() != null) {
            ArrayList<Block> result = new ArrayList<Block>(5);
            ASTNode child = this.myNode.getFirstChildNode();
            while (child != null) {
                if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                    child = this.processChild(result, child, this.getDefaultWrap(child), null, this.getChildDefaultIndent());
                }
                if (child == null) continue;
                LOG.assertTrue(child.getTreeParent() == this.myNode);
                child = child.getTreeNext();
            }
            return result;
        }
        return EMPTY;
    }

    private List<Block> splitAttribute(ASTNode node, XmlFormattingPolicy formattingPolicy) {
        ArrayList<Block> result = new ArrayList<Block>(3);
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE_START_DELIMITER || child.getElementType() == XmlElementType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                result.add((Block)new XmlBlock(child, null, null, formattingPolicy, null, null));
                continue;
            }
            if (!child.getPsi().getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && XmlBlock.containsOuterLanguageElement(child)) {
                result.add((Block)new XmlBlock(child, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null));
                continue;
            }
            if (child.getElementType() == TokenType.ERROR_ELEMENT) continue;
            result.add((Block)new ReadOnlyBlock(child));
        }
        return result;
    }

    private static boolean containsOuterLanguageElement(ASTNode node) {
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    private List<Block> splitComment() {
        if (this.myNode.getElementType() != XmlElementType.XML_COMMENT) {
            return EMPTY;
        }
        ArrayList<Block> result = new ArrayList<Block>(3);
        boolean hasOuterLangElements = false;
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child instanceof OuterLanguageElement) {
                hasOuterLangElements = true;
            }
            result.add((Block)new XmlBlock(child, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null));
        }
        if (hasOuterLangElements) {
            return result;
        }
        return EMPTY;
    }

    @Nullable
    protected Wrap getDefaultWrap(ASTNode node) {
        return null;
    }

    @Nullable
    protected Indent getChildDefaultIndent() {
        if (this.myNode.getElementType() == XmlElementType.HTML_DOCUMENT) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == TokenType.DUMMY_HOLDER) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == XmlElementType.XML_PROLOG) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        IElementType elementType = this.myNode.getElementType();
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if ((this.isXmlTag(node2) || type2 == XmlElementType.XML_END_TAG_START || type2 == XmlElementType.XML_TEXT) && this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (elementType == XmlElementType.XML_TEXT) {
            return this.getSpacesInsideText(type1, type2);
        }
        if (elementType == XmlElementType.XML_ATTRIBUTE) {
            return this.getSpacesInsideAttribute(type1, type2);
        }
        if (type1 == XmlElementType.XML_PROLOG) {
            return this.createDefaultSpace(true, false);
        }
        if (elementType == XmlElementType.XML_DOCTYPE) {
            return this.createDefaultSpace(true, false);
        }
        return this.createDefaultSpace(false, false);
    }

    private Spacing getSpacesInsideAttribute(IElementType type1, IElementType type2) {
        if (type1 == XmlElementType.XML_EQ || type2 == XmlElementType.XML_EQ) {
            int spaces = this.myXmlFormattingPolicy.getShouldAddSpaceAroundEqualityInAttribute() ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(false, false);
    }

    private Spacing getSpacesInsideText(IElementType type1, IElementType type2) {
        if (type1 == XmlElementType.XML_DATA_CHARACTERS && type2 == XmlElementType.XML_DATA_CHARACTERS) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(false, true);
    }

    @Override
    public Indent getIndent() {
        if (this.myNode.getElementType() == XmlElementType.XML_PROLOG || this.myNode.getElementType() == XmlElementType.XML_DOCTYPE || SourceTreeToPsiMap.treeElementToPsi(this.myNode) instanceof XmlDocument) {
            return Indent.getNoneIndent();
        }
        return this.myIndent;
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return this.myNode.getElementType() == XmlElementType.XML_TEXT || this.myNode.getElementType() == XmlElementType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlElementType.XML_CHAR_ENTITY_REF;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.myNode.getPsi() instanceof PsiFile) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlBlock.getChildAttributes must not return null");
    }

    public XmlFormattingPolicy getPolicy() {
        return this.myXmlFormattingPolicy;
    }
}

