/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InjectedLanguageBlockWrapper
implements Block {
    final Block myOriginal;
    private final int myOffset;
    private List<Block> myBlocks;

    public InjectedLanguageBlockWrapper(Block original, int offset) {
        this.myOriginal = original;
        this.myOffset = offset;
    }

    public Indent getIndent() {
        return this.myOriginal.getIndent();
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myOriginal.getAlignment();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange range = this.myOriginal.getTextRange();
        TextRange textRange = new TextRange(this.myOffset + range.getStartOffset(), this.myOffset + range.getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/InjectedLanguageBlockWrapper.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myBlocks == null) {
            this.myBlocks = InjectedLanguageBlockWrapper.buildBlocks(this.myOriginal, this.myOffset, null);
        }
        List<Block> list = this.myBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/InjectedLanguageBlockWrapper.getSubBlocks must not return null");
        }
        return list;
    }

    static List<Block> buildBlocks(Block myOriginal, int myOffset, TextRange range) {
        List list = myOriginal.getSubBlocks();
        if (list.size() == 0) {
            return AbstractXmlBlock.EMPTY;
        }
        ArrayList<Block> result = new ArrayList<Block>(list.size());
        if (range == null) {
            for (Block b : list) {
                result.add(new InjectedLanguageBlockWrapper(b, myOffset));
            }
        } else {
            InjectedLanguageBlockWrapper.collectBlocksIntersectingRange(list, result, range, myOffset);
        }
        return result;
    }

    private static void collectBlocksIntersectingRange(List<Block> list, List<Block> result, TextRange range, int blockStartOffset) {
        for (Block b : list) {
            TextRange textRange = b.getTextRange();
            if (range.contains(textRange)) {
                result.add(new InjectedLanguageBlockWrapper(b, blockStartOffset - range.getStartOffset()));
                continue;
            }
            if (!textRange.intersectsStrict(range)) continue;
            InjectedLanguageBlockWrapper.collectBlocksIntersectingRange(b.getSubBlocks(), result, range, blockStartOffset);
        }
    }

    @Nullable
    public Wrap getWrap() {
        return this.myOriginal.getWrap();
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof InjectedLanguageBlockWrapper) {
            child1 = ((InjectedLanguageBlockWrapper)child1).myOriginal;
        }
        if (child2 instanceof InjectedLanguageBlockWrapper) {
            child2 = ((InjectedLanguageBlockWrapper)child2).myOriginal;
        }
        return this.myOriginal.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/InjectedLanguageBlockWrapper.getChildAttributes must not return null");
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myOriginal.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myOriginal.isLeaf();
    }
}

