/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.pom.java.PomJavaAspect;
import com.intellij.pom.java.events.JavaTreeChanged;
import com.intellij.pom.java.events.PomJavaAspectChangeSet;
import com.intellij.pom.java.events.PomJavaChange;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PomJavaAspectImpl
extends PomJavaAspect
implements ProjectComponent {
    private final PsiManager myPsiManager;
    private final PomModel myPomModel;

    public PomJavaAspectImpl(PsiManager psiManager, TreeAspect treeAspect, PomModel pomModel) {
        this.myPsiManager = psiManager;
        this.myPomModel = pomModel;
        pomModel.registerAspect(PomJavaAspect.class, (PomModelAspect)this, Collections.singleton(treeAspect));
    }

    public LanguageLevel getLanguageLevel() {
        return LanguageLevelProjectExtension.getInstance((Project)this.myPsiManager.getProject()).getLanguageLevel();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("PomJavaModel" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/java/impl/PomJavaAspectImpl.getComponentName must not return null");
        }
        return "PomJavaModel";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void update(PomModelEvent event) {
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet(this.myPomModel.getModelAspect(TreeAspect.class));
        if (changeSet == null) {
            return;
        }
        PsiFile containingFile = changeSet.getRootElement().getPsi().getContainingFile();
        if (!(containingFile.getLanguage() instanceof JavaLanguage)) {
            return;
        }
        PomJavaAspectChangeSet set = new PomJavaAspectChangeSet(this.myPomModel, containingFile);
        set.addChange((PomJavaChange)new JavaTreeChanged(containingFile));
        event.registerChangeSet((PomModelAspect)this, (PomChangeSet)set);
    }
}

