/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import org.jetbrains.annotations.NotNull;

public class ArtifactPointerImpl
implements ArtifactPointer {
    private String myName;
    private Artifact myArtifact;

    public ArtifactPointerImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.<init> must not be null");
        }
        this.myName = name;
    }

    public ArtifactPointerImpl(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.<init> must not be null");
        }
        this.myArtifact = artifact;
        this.myName = artifact.getName();
    }

    @NotNull
    public String getArtifactName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.getArtifactName must not return null");
        }
        return string;
    }

    public Artifact getArtifact() {
        return this.myArtifact;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getArtifactName(@NotNull ArtifactModel artifactModel) {
        String string;
        if (artifactModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.getArtifactName must not be null");
        }
        if (this.myArtifact != null) {
            string = artifactModel.getArtifactByOriginal(this.myArtifact).getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.getArtifactName must not return null");
            return string;
        }
        string = this.myName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.getArtifactName must not return null");
    }

    public Artifact findArtifact(@NotNull ArtifactModel artifactModel) {
        if (artifactModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/artifacts/ArtifactPointerImpl.findArtifact must not be null");
        }
        if (this.myArtifact != null) {
            return artifactModel.getArtifactByOriginal(this.myArtifact);
        }
        return artifactModel.findArtifact(this.myName);
    }

    void setArtifact(Artifact artifact) {
        this.myArtifact = artifact;
    }

    void setName(String name) {
        this.myName = name;
    }
}

