/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarCustomComponentFactory;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.InsertOverwritePanel;
import com.intellij.openapi.wm.impl.status.MemoryUsagePanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.NotificationPopup;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarImpl
extends JPanel
implements StatusBarEx {
    private final PositionPanel myPositionPanel = new PositionPanel(this);
    private final ToggleReadOnlyAttributePanel myToggleReadOnlyAttributePanel = new ToggleReadOnlyAttributePanel(this);
    private final EncodingPanel myEncodingPanel = new EncodingPanel(this);
    private final IdeNotificationArea myNotificationArea = new IdeNotificationArea(this);
    private final MemoryUsagePanel myMemoryUsagePanel = new MemoryUsagePanel();
    private final InsertOverwritePanel myInsertOverwritePanel = new InsertOverwritePanel();
    private final IdeMessagePanel myMessagePanel = new IdeMessagePanel(MessagePool.getInstance());
    private final JPanel myCustomIndicationsPanel = new JPanel(new GridBagLayout());
    private final JPanel myAppLevelCustomIndicationsPanel = new JPanel(new GridBagLayout());
    private String myInfo = "";
    private final MyUISettingsListener myUISettingsListener;
    private InfoAndProgressPanel myInfoAndProgressPanel;
    private final UISettings myUISettings;
    private AsyncProcessIcon myRefreshIcon;
    private EmptyIcon myEmptyRefreshIcon;
    private final List<StatusBarPatch> myFileStatusComponents = new ArrayList<StatusBarPatch>();
    private final List<StatusBarPatch> myPatches = new ArrayList<StatusBarPatch>();
    private JPanel myPatchesPanel;
    private List<StatusBarCustomComponentFactory> myCustomComponentsFactoryList;
    private final Map<StatusBarCustomComponentFactory, JComponent> myFactory2Component = new HashMap();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.status.StatusBarImpl");

    public StatusBarImpl(UISettings uiSettings) {
        this.myUISettings = uiSettings;
        this.constructUI();
        this.myUISettingsListener = new MyUISettingsListener();
    }

    private void constructUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.myRefreshIcon = new AsyncProcessIcon("Refreshing filesystem"){

            protected Icon getPassiveIcon() {
                return StatusBarImpl.this.myEmptyRefreshIcon;
            }
        };
        this.myEmptyRefreshIcon = new EmptyIcon(this.myRefreshIcon.getPreferredSize().width, this.myRefreshIcon.getPreferredSize().height);
        this.myInfoAndProgressPanel = new InfoAndProgressPanel(this);
        this.setRefreshVisible(false);
        NonOpaquePanel center = new NonOpaquePanel((LayoutManager)new BorderLayout());
        center.add((Component)this.myRefreshIcon, (Object)"West");
        center.add((Component)this.myInfoAndProgressPanel, (Object)"Center");
        this.myPatchesPanel = new JPanel(new GridBagLayout());
        this.myPatchesPanel.setOpaque(false);
        this.setBorder(new EmptyBorder(2, 0, 1, 0));
        this.add((Component)center, "Center");
        this.add((Component)this.myPatchesPanel, "East");
        this.recreatePatches();
    }

    @Override
    public IdeNotificationArea getNotificationArea() {
        return this.myNotificationArea;
    }

    private void recreatePatches() {
        this.myPatchesPanel.removeAll();
        this.myPatches.clear();
        this.addPatch(this.myPositionPanel, true);
        this.addPatch(this.myToggleReadOnlyAttributePanel, true);
        this.addPatch(this.myInsertOverwritePanel, true);
        this.addPatch(this.myEncodingPanel, true);
        for (int i = 0; i < this.myFileStatusComponents.size(); ++i) {
            StatusBarPatch component = this.myFileStatusComponents.get(i);
            this.addPatch(component, i == 0);
        }
        this.addPatch(new StatusBarPatch(){

            @Override
            public JComponent getComponent() {
                return StatusBarImpl.this.myCustomIndicationsPanel;
            }

            @Override
            public String updateStatusBar(Editor selected, JComponent componentSelected) {
                return componentSelected == null ? null : componentSelected.getToolTipText();
            }

            @Override
            public void clear() {
            }
        }, true);
        this.addPatch(new StatusBarPatch(){

            @Override
            public JComponent getComponent() {
                return StatusBarImpl.this.myAppLevelCustomIndicationsPanel;
            }

            @Override
            public String updateStatusBar(Editor selected, JComponent componentSelected) {
                return componentSelected == null ? null : componentSelected.getToolTipText();
            }

            @Override
            public void clear() {
            }
        }, true);
        this.addPatch(this.myMessagePanel, false);
        this.addPatch(this.myNotificationArea, true);
        this.addPatch(this.myMemoryUsagePanel, true);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.anchor = 17;
        for (int i = 0; i < this.myPatches.size(); ++i) {
            StatusBarPatch patch = this.myPatches.get(i);
            JComponent component = patch.getComponent();
            if (i == this.myPatches.size() - 1) {
                gbConstraints.fill = 3;
                gbConstraints.gridwidth = 0;
            }
            this.myPatchesPanel.add((Component)component, gbConstraints);
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            ++gbConstraints.gridx;
        }
    }

    public void setCustomComponentsFactory(List<StatusBarCustomComponentFactory> customComponentsFactory) {
        this.disposeAppLevelCustomComponents();
        this.myCustomComponentsFactoryList = customComponentsFactory;
        for (StatusBarCustomComponentFactory factory : this.myCustomComponentsFactoryList) {
            JComponent c = factory.createComponent((StatusBar)this);
            if (c == null) continue;
            this.addAppLevelCustomIndicationComponent(c);
        }
    }

    private void setRefreshVisible(boolean visible) {
        if (visible) {
            this.myRefreshIcon.resume();
        } else {
            this.myRefreshIcon.suspend();
        }
    }

    @Override
    public void add(ProgressIndicatorEx indicator, TaskInfo info) {
        this.myInfoAndProgressPanel.addProgress(indicator, info);
    }

    @Override
    public void setProcessWindowOpen(boolean open) {
        this.myInfoAndProgressPanel.setProcessWindowOpen(open);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.notifyProgressByBalloon must not be null");
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.notifyProgressByBalloon must not be null");
        }
        return this.notifyProgressByBalloon(type, htmlBody, null, null);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull String htmlBody, @Nullable Icon icon, @Nullable HyperlinkListener listener) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.notifyProgressByBalloon must not be null");
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.notifyProgressByBalloon must not be null");
        }
        return this.myInfoAndProgressPanel.notifyByBalloon(type, htmlBody, icon, listener);
    }

    @Override
    public void update(Editor editor) {
        Document document;
        if (editor != null && (document = editor.getDocument()) instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        for (StatusBarPatch patch : this.myPatches) {
            try {
                patch.updateStatusBar(editor, null);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        this.disposeAppLevelCustomComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAppLevelCustomComponents() {
        if (this.myCustomComponentsFactoryList != null) {
            for (StatusBarCustomComponentFactory factory : this.myCustomComponentsFactoryList) {
                try {
                    JComponent c = this.myFactory2Component.get(factory);
                    if (c == null) continue;
                    factory.disposeComponent((StatusBar)this, c);
                }
                finally {
                    this.myFactory2Component.remove(factory);
                }
            }
        }
        this.myCustomComponentsFactoryList = null;
    }

    Editor getEditor() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return StatusBarImpl.getEditor(project);
    }

    private static Editor getEditor(Project project) {
        return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    private Project getProject() {
        return (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
    }

    @Override
    public boolean isProcessWindowOpen() {
        return this.myInfoAndProgressPanel.isProcessWindowOpen();
    }

    @Override
    protected final void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Color dark = this.getBackground().darker();
        g.setColor(dark);
        g.drawLine(0, 0, this.getWidth(), 0);
        Color lighter = new Color(dark.getRed(), dark.getGreen(), dark.getBlue(), 75);
        g.setColor(lighter);
        g.drawLine(0, 1, this.getWidth(), 1);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this.setMemoryIndicatorVisible(this.myUISettings.SHOW_MEMORY_INDICATOR);
        this.myUISettings.addUISettingsListener((UISettingsListener)this.myUISettingsListener);
    }

    @Override
    public final void removeNotify() {
        UISettings.getInstance().removeUISettingsListener((UISettingsListener)this.myUISettingsListener);
        super.removeNotify();
    }

    public final void setInfo(final @Nullable String s) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                StatusBarImpl.this.myInfo = s;
                StatusBarImpl.this.myInfoAndProgressPanel.setText(s != null ? s : " ");
            }
        });
    }

    public void fireNotificationPopup(@NotNull JComponent content, Color backgroundColor) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.fireNotificationPopup must not be null");
        }
        new NotificationPopup(this, content, backgroundColor);
    }

    @Override
    public final String getInfo() {
        return this.myInfo;
    }

    private void addAppLevelCustomIndicationComponent(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.addAppLevelCustomIndicationComponent must not be null");
        }
        StatusBarImpl.addCustomIndicationComponent(c, this.myAppLevelCustomIndicationsPanel);
    }

    public final void addCustomIndicationComponent(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.addCustomIndicationComponent must not be null");
        }
        StatusBarImpl.addCustomIndicationComponent(c, this.myCustomIndicationsPanel);
    }

    private static void addCustomIndicationComponent(JComponent c, JPanel indicationsPanel) {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.insets = new Insets(0, 0, 0, 2);
        indicationsPanel.setVisible(true);
        indicationsPanel.add((Component)c, gbConstraints);
    }

    public void removeCustomIndicationComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarImpl.removeCustomIndicationComponent must not be null");
        }
        StatusBarImpl.removeCustomIndicationComponent(component, this.myCustomIndicationsPanel);
    }

    private static void removeCustomIndicationComponent(JComponent component, JPanel indicationsPanel) {
        indicationsPanel.remove(component);
        if (indicationsPanel.getComponentCount() == 0) {
            indicationsPanel.setVisible(false);
        }
    }

    @Override
    public final void clear() {
        for (StatusBarPatch patch : this.myPatches) {
            patch.clear();
        }
    }

    @Override
    public void addFileStatusComponent(StatusBarPatch component) {
        this.myFileStatusComponents.add(component);
        this.recreatePatches();
    }

    @Override
    public void removeFileStatusComponent(StatusBarPatch component) {
        this.myFileStatusComponents.remove(component);
        this.recreatePatches();
    }

    @Override
    public void cleanupCustomComponents() {
        this.myCustomIndicationsPanel.removeAll();
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMinimumSize();
        return new Dimension(m.width, p.height);
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension p = super.getPreferredSize();
        Dimension m = super.getMaximumSize();
        return new Dimension(m.width, p.height);
    }

    private void setMemoryIndicatorVisible(boolean state) {
        if (this.myMemoryUsagePanel != null) {
            this.myMemoryUsagePanel.setVisible(state);
        }
    }

    public void startRefreshIndication(String tooltipText) {
        this.myRefreshIcon.setToolTipText(tooltipText);
        this.setRefreshVisible(true);
    }

    public void stopRefreshIndication() {
        this.setRefreshVisible(false);
    }

    private void addPatch(StatusBarPatch panel, boolean separator) {
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        CompoundBorder separatorLeft = BorderFactory.createCompoundBorder(emptyBorder, new SeparatorBorder.Left());
        this.myPatches.add(panel);
        JComponent component = panel.getComponent();
        if (separator) {
            component.setBorder(separatorLeft);
        } else {
            component.setBorder(emptyBorder);
        }
        component.setOpaque(false);
    }

    public static class SeparatorBorder
    implements Border {
        private final boolean myLeft;

        public SeparatorBorder(boolean left) {
            this.myLeft = left;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color bg = c.getBackground();
            g.setColor(bg != null ? bg.darker() : Color.darkGray);
            boolean inset = true;
            if (this.myLeft) {
                g.drawLine(0, 1, 0, c.getHeight() - 1 - 1);
            } else {
                g.drawLine(c.getWidth() - 1, 1, c.getWidth() - 1, c.getHeight() - 1 - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 0, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        public static class Left
        extends SeparatorBorder {
            public Left() {
                super(true);
            }
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            StatusBarImpl.this.setMemoryIndicatorVisible(uiSettings.SHOW_MEMORY_INDICATOR);
        }
    }
}

