/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.DirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupByPackages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class GroupTreeNode
extends AbstractTreeNode
implements Disposable {
    private final String myName;
    private final boolean mySupportsDeletion;
    private final List<String> myFilePaths = new ArrayList<String>();
    private final Map<String, String> myErrorsMap;
    private final SimpleTextAttributes myInvalidAttributes;
    private final Project myProject;

    public GroupTreeNode(String name, boolean supportsDeletion, SimpleTextAttributes invalidAttributes, Project project, Map<String, String> errorsMap) {
        this.myName = name;
        this.mySupportsDeletion = supportsDeletion;
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myErrorsMap = errorsMap;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        String iconName = expanded ? "folderOpen" : "folder";
        return IconLoader.getIcon((String)("/nodes/" + iconName + ".png"));
    }

    @Override
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.addAll(((AbstractTreeNode)this.getChildAt(i)).getVirtualFiles());
        }
        return result;
    }

    @Override
    public Collection<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.addAll(((AbstractTreeNode)this.getChildAt(i)).getFiles());
        }
        return result;
    }

    @Override
    protected int getItemsCount() {
        int result = 0;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            AbstractTreeNode treeNode = (AbstractTreeNode)children.nextElement();
            result += treeNode.getItemsCount();
        }
        return result;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    public SimpleTextAttributes getAttributes() {
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    @Override
    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void addFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/GroupTreeNode.addFilePath must not be null");
        }
        this.myFilePaths.add(filePath);
    }

    public void rebuild(boolean groupByPackages) {
        if (this.containsGroups()) {
            this.rebuildGroups(groupByPackages);
        } else {
            this.rebuildFiles(groupByPackages);
        }
    }

    private void rebuildGroups(boolean groupByPackages) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((GroupTreeNode)this.getChildAt(i)).rebuild(groupByPackages);
        }
    }

    private void rebuildFiles(boolean groupByPackages) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            TreeNode node = this.getChildAt(i);
            if (!(node instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)node));
        }
        this.removeAllChildren();
        if (groupByPackages) {
            this.buildPackages();
        } else {
            this.buildFiles();
        }
        this.setTreeModel(this.myTreeModel);
        if (this.myTreeModel != null) {
            this.myTreeModel.nodeStructureChanged(this);
        }
    }

    private void buildPackages() {
        ArrayList<File> files = new ArrayList<File>();
        for (String myFilePath : this.myFilePaths) {
            files.add(new File(myFilePath));
        }
        GroupByPackages groupByPackages = new GroupByPackages(files);
        List<File> roots = groupByPackages.getRoots();
        this.addFiles(this, roots, files, groupByPackages, null);
    }

    private void addFiles(AbstractTreeNode parentNode, List<File> roots, final ArrayList<File> files, GroupByPackages groupByPackages, String parentPath) {
        if (roots == null) {
            return;
        }
        Collections.sort(roots, new Comparator<File>(){

            @Override
            public int compare(File file, File file1) {
                if (files.contains(file) == files.contains(file1)) {
                    return file.getAbsolutePath().compareToIgnoreCase(file1.getAbsolutePath());
                }
                if (files.contains(file)) {
                    return 1;
                }
                return -1;
            }
        });
        for (File root : roots) {
            FileOrDirectoryTreeNode child = files.contains(root) ? new FileTreeNode(root.getAbsolutePath(), this.myInvalidAttributes, this.myProject, parentPath) : new DirectoryTreeNode(root.getAbsolutePath(), this.myProject, parentPath);
            Disposer.register((Disposable)((Disposable)parentNode), (Disposable)child);
            parentNode.add(child);
            this.addFiles(child, groupByPackages.getChildren(root), files, groupByPackages, child.getFilePath());
        }
    }

    private void buildFiles() {
        Collections.sort(this.myFilePaths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                return path1.compareToIgnoreCase(path2);
            }
        });
        for (String filePath : this.myFilePaths) {
            FileTreeNode child = new FileTreeNode(filePath, this.myInvalidAttributes, this.myProject, null);
            String error = this.myErrorsMap.get(filePath);
            if (error != null) {
                child.setErrorText(error);
            }
            this.add(child);
            Disposer.register((Disposable)this, (Disposable)child);
        }
    }

    private boolean containsGroups() {
        return this.myFilePaths.isEmpty();
    }

    public void dispose() {
    }
}

