/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import java.util.List;

public class UnshelveChangesAction
extends AnAction {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.UnshelveChangesAction");

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        List changes = (List)e.getData(ShelvedChangesViewManager.SHELVED_CHANGE_KEY);
        List binaryFiles = (List)e.getData(ShelvedChangesViewManager.SHELVED_BINARY_FILE_KEY);
        if (changes != null && binaryFiles != null && changes.size() == 0 && binaryFiles.size() == 0) {
            changes = null;
            binaryFiles = null;
        }
        this.LOG.assertTrue(changeLists != null);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        List allChangeLists = changeListManager.getChangeListsCopy();
        LocalChangeList defaultChangeList = changeListManager.getDefaultChangeList();
        String defaultName = changeLists.length == 1 ? changeLists[0].DESCRIPTION : null;
        ChangeListChooser chooser = new ChangeListChooser(project, allChangeLists, (ChangeList)defaultChangeList, VcsBundle.message((String)"unshelve.changelist.chooser.title", (Object[])new Object[0]), defaultName);
        chooser.show();
        if (!chooser.isOK()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (ShelvedChangeList changeList : changeLists) {
            ShelveChangesManager.getInstance(project).unshelveChangeList(changeList, changes, binaryFiles, chooser.getSelectedList());
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project != null && changes != null);
    }
}

